/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    static Logger logger = LoggerFactory.getLogger(MD5Util.class);
    private static HashFunction hf = Hashing.md5();
    private static Charset defaultCharset = Charset.forName("UTF-8");

    private MD5Util() {
        throw new AssertionError((Object)"\u4e0d\u8981\u5b9e\u4f8b\u5316\u5de5\u5177\u7c7b\u54e6");
    }

    public static String md5(String data) {
        HashCode hash = hf.newHasher().putString((CharSequence)data, defaultCharset).hash();
        return hash.toString();
    }

    public static String md5(String data, Charset charset, boolean isUpperCase) {
        HashCode hash = hf.newHasher().putString((CharSequence)data, charset == null ? defaultCharset : charset).hash();
        return isUpperCase ? hash.toString().toUpperCase() : hash.toString();
    }

    public static String md5(byte[] bytes, boolean isUpperCase) {
        HashCode hash = hf.newHasher().putBytes(bytes).hash();
        return isUpperCase ? hash.toString().toUpperCase() : hash.toString();
    }

    public static String md5(File sourceFile, boolean isUpperCase) {
        HashCode hash = hf.newHasher().putObject((Object)sourceFile, (Funnel)new Funnel<File>(){
            private static final long serialVersionUID = 2757585325527511209L;

            public void funnel(File from, PrimitiveSink into) {
                try {
                    into.putBytes(Files.toByteArray((File)from));
                }
                catch (IOException e) {
                    logger.info("MD5Util md5 IOException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        }).hash();
        return isUpperCase ? hash.toString().toUpperCase() : hash.toString();
    }

    public static String md5(Object object, boolean isUpperCase, Charset charset) {
        Hasher hasher = hf.newHasher();
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.info("MD5Util md5 JsonProcessingException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
        }
        HashCode hash = hasher.putString((CharSequence)json, charset == null ? defaultCharset : charset).hash();
        return isUpperCase ? hash.toString().toUpperCase() : hash.toString();
    }

    public static String md5(final Object object, final List<String> fieldNames, boolean isUpperCase, final Charset charset) {
        HashCode hash = hf.newHasher().putObject(object, (Funnel)new Funnel<Object>(){
            private static final long serialVersionUID = -5236251432355557848L;

            public void funnel(Object from, PrimitiveSink into) {
                Map allField = MD5Util.getAllField(object);
                for (String fieldName : fieldNames) {
                    try {
                        if (fieldName.contains(".")) {
                            MD5Util.handleDeepField(object, charset, into, allField, fieldName);
                            continue;
                        }
                        MD5Util.handleField(object, charset, into, allField, fieldName);
                    }
                    catch (Exception e) {
                        logger.info("MD5Util md5\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }).hash();
        return isUpperCase ? hash.toString().toUpperCase() : hash.toString();
    }

    private static void handleDeepField(Object tempValue, Charset charset, PrimitiveSink into, Map<String, Field> tempAllField, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        String[] names;
        Field field = null;
        for (String name : names = fieldName.split("\\.")) {
            field = tempAllField.get(name);
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            field.setAccessible(true);
            tempValue = field.get(tempValue);
            field.setAccessible(false);
            tempAllField = MD5Util.getAllField(tempValue);
        }
        MD5Util.stuffFieldValue(tempValue, charset, into);
    }

    private static void handleField(Object object, Charset charset, PrimitiveSink into, Map<String, Field> allField, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = allField.get(fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        field.setAccessible(true);
        Object tempValue = field.get(object);
        MD5Util.stuffFieldValue(tempValue, charset, into);
        field.setAccessible(false);
    }

    private static void stuffFieldValue(Object value, Charset charset, PrimitiveSink into) throws IllegalAccessException {
        if (value instanceof Integer) {
            into.putInt(((Integer)value).intValue());
        } else if (value instanceof Long) {
            into.putLong(((Long)value).longValue());
        } else if (value instanceof Float) {
            into.putFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            into.putDouble(((Double)value).doubleValue());
        } else if (value instanceof Short) {
            into.putShort(((Short)value).shortValue());
        } else if (value instanceof Byte) {
            into.putByte(((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            into.putBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Character) {
            into.putChar(((Character)value).charValue());
        } else if (value instanceof String) {
            into.putString((CharSequence)((String)value), charset == null ? defaultCharset : charset);
        } else {
            throw new IllegalArgumentException(value.getClass() + " is not basic data type");
        }
    }

    private static Map<String, Field> getAllField(Object object) {
        HashMap fieldMap = Maps.newHashMap();
        if (object.getClass().isAssignableFrom(Object.class)) {
            return fieldMap;
        }
        Class<Object> tempClass = object.getClass();
        Field[] declaredFields = null;
        do {
            for (Field field : declaredFields = tempClass.getDeclaredFields()) {
                fieldMap.put(field.getName(), field);
            }
        } while (!(tempClass = tempClass.getSuperclass()).isAssignableFrom(Object.class));
        return fieldMap;
    }

    public static String encryptMd5Hash(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer hasHexString = new StringBuffer();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes(), 0, s.length());
            byte[] messageDigest = digest.digest();
            hasHexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String hex = Integer.toHexString(0xFF & messageDigest[i]);
                if (hex.length() == 1) {
                    hasHexString.append('0');
                }
                hasHexString.append(hex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.info("MD5Util encryptMD5Hash NoSuchAlgorithmException\u5f02\u5e38:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
        }
        return hasHexString.toString();
    }
}

