/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.tiktokmembers.common.utils.GenAuthWithBindValidUrlDto;
import com.bizvane.tiktokmembers.common.utils.SignUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GenAuthWithBindUrlUtil {
    private static final String AuthUrl = "https://auth.dylk.com/auth-isv/";

    public static String GenAuthWithBindValidUrlFast(String appKey, String appSecret, List<String> permissionKeys, String outShopId, String solutionKey, String extra) {
        GenAuthWithBindValidUrlDto dto = new GenAuthWithBindValidUrlDto();
        dto.setTimestamp(String.valueOf(System.currentTimeMillis() / 1000L));
        dto.setSolutionKey(solutionKey);
        dto.setExtra(extra);
        dto.setPermissionKeys(permissionKeys);
        dto.setOutShopId(outShopId);
        return GenAuthWithBindUrlUtil.GenAuthWithBindValidUrl(dto, appKey, appSecret);
    }

    public static String GenAuthWithBindValidUrl(GenAuthWithBindValidUrlDto dto, String appKey, String appSecret) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("client_key", appKey);
        query.put("timestamp", dto.getTimestamp());
        query.put("charset", "UTF-8");
        query.put("solution_key", dto.getSolutionKey());
        if (StringUtils.isNotBlank((CharSequence)dto.getOutShopId())) {
            query.put("out_shop_id", dto.getOutShopId());
        }
        query.put("permission_keys", String.join((CharSequence)",", dto.getPermissionKeys()));
        if (StringUtils.isNotBlank((CharSequence)dto.getExtra())) {
            query.put("extra", dto.getExtra());
        }
        System.out.println("appSecret:" + appSecret + "query:" + JSONObject.toJSONString(query));
        String signResult = SignUtil.SignV2(appSecret, "", query);
        query.put("sign", signResult);
        String queryStr = query.entrySet().stream().map(entry -> new StringBuilder().append((String)entry.getKey()).append("=").append((String)entry.getValue())).collect(Collectors.joining("&"));
        StringBuilder resultSb = new StringBuilder(AuthUrl).append("?").append(queryStr);
        return resultSb.toString();
    }
}

