/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private static Logger logger = LoggerFactory.getLogger(EncryptUtil.class);
    private static final String secret = "85131fef2ed7d41d9eac11ccf94834d0";
    private static final String key = EncryptUtil.parseSecret("85131fef2ed7d41d9eac11ccf94834d0");
    private static final String iv = "85131fef2ed7d41d9eac11ccf94834d0".substring(16);

    public static String encryptAES(String data) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int blockSize = cipher.getBlockSize();
            byte[] dataBytes = data.getBytes();
            int plaintextLength = dataBytes.length;
            if (plaintextLength % blockSize != 0) {
                plaintextLength += blockSize - plaintextLength % blockSize;
            }
            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            cipher.init(1, (Key)keyspec, ivspec);
            byte[] encrypted = cipher.doFinal(plaintext);
            System.out.println(encrypted);
            return EncryptUtil.encode(encrypted).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptAES(String data) throws Exception {
        try {
            byte[] encrypted1 = EncryptUtil.decode(data);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)keyspec, ivspec);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original);
            return originalString.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String SHA256(String input) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            result = EncryptUtil.bytes2Hex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String bytes2Hex(byte[] bts) {
        StringBuilder hexSb = new StringBuilder();
        for (byte b : bts) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexSb.append('0');
            }
            hexSb.append(hex);
        }
        return hexSb.toString();
    }

    public static String encode(byte[] byteArray) {
        return new String(Base64.getEncoder().encode(byteArray));
    }

    public static byte[] decode(String base64EncodedString) {
        return Base64.getDecoder().decode(base64EncodedString);
    }

    private static String parseSecret(String secret) {
        logger.info("EncryptUtil-info,secret:{}", (Object)secret);
        secret = EncryptUtil.fillSecret(secret);
        secret = EncryptUtil.cutSecret(secret);
        return secret;
    }

    private static String cutSecret(String secret) {
        if (secret.length() <= 32) {
            return secret;
        }
        int rightCnt = (secret.length() - 32) / 2;
        int leftCnt = secret.length() - 32 - rightCnt;
        return secret.substring(leftCnt, 32 + leftCnt);
    }

    private static String fillSecret(String secret) {
        int i;
        if (secret.length() >= 32) {
            return secret;
        }
        int rightCnt = (32 - secret.length()) / 2;
        int leftCnt = 32 - secret.length() - rightCnt;
        StringBuilder sb = new StringBuilder("");
        for (i = 0; i < leftCnt; ++i) {
            sb.append('#');
        }
        sb.append(secret);
        for (i = 0; i < rightCnt; ++i) {
            sb.append('#');
        }
        return sb.toString();
    }
}

