/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.service.impl;

import com.bizvane.tiktokmembers.common.mapper.MbrTiktokMerchantAuthPOMapper;
import com.bizvane.tiktokmembers.common.models.po.MbrTiktokMerchantAuthPO;
import com.bizvane.tiktokmembers.common.models.po.MbrTiktokMerchantAuthPOExample;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokMerchantAuthRequestVO;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokMerchantAuthResultVO;
import com.bizvane.tiktokmembers.common.properties.SystemProperties;
import com.bizvane.tiktokmembers.common.service.TiktokMerchantAuthService;
import com.bizvane.tiktokmembers.common.utils.GenAuthWithBindUrlUtil;
import com.bizvane.tiktokmembers.common.utils.ResponseUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Api(value="\u6296\u97f3\u4f1a\u5458\u901a\u5546\u5bb6\u6388\u6743\u63a5\u53e3\u5b9e\u73b0\u7c7b", tags={"\u6296\u97f3\u4f1a\u5458\u901a\u5546\u5bb6\u6388\u6743\u63a5\u53e3\u5b9e\u73b0\u7c7b"})
@Service
public class TiktokMerchantAuthServiceImpl
implements TiktokMerchantAuthService {
    private static final Logger log = LoggerFactory.getLogger(TiktokMerchantAuthServiceImpl.class);
    @Autowired
    private MbrTiktokMerchantAuthPOMapper mbrTiktokMerchantAuthPOMapper;
    @Autowired
    private SystemProperties systemProperties;

    @Override
    public ResponseData<PageInfo<MbrTiktokMerchantAuthResultVO>> pageList(MbrTiktokMerchantAuthRequestVO requestVO) {
        Long sysCompanyId = requestVO.getSysCompanyId();
        Long sysBrandId = requestVO.getSysBrandId();
        MbrTiktokMerchantAuthPOExample poExample = new MbrTiktokMerchantAuthPOExample();
        MbrTiktokMerchantAuthPOExample.Criteria criteria = poExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(1);
        if (requestVO.getBindStatus() != null) {
            criteria.andBindStatusEqualTo(requestVO.getBindStatus());
        }
        poExample.setOrderByClause(" mbr_tiktok_merchant_auth_id desc ");
        PageHelper.startPage((int)requestVO.getPageNo(), (int)requestVO.getPageSize());
        List<MbrTiktokMerchantAuthPO> poList = this.mbrTiktokMerchantAuthPOMapper.selectByExample(poExample);
        if (CollectionUtils.isEmpty(poList)) {
            return new ResponseData((Object)new PageInfo(new ArrayList()));
        }
        PageInfo poPageInfo = new PageInfo(poList);
        PageInfo voPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)poPageInfo, (Object)voPageInfo, (String[])new String[]{"list"});
        List voList = poList.stream().map(item -> {
            MbrTiktokMerchantAuthResultVO resultVO = new MbrTiktokMerchantAuthResultVO();
            BeanUtils.copyProperties((Object)item, (Object)resultVO);
            return resultVO;
        }).collect(Collectors.toList());
        voPageInfo.setList(voList);
        return new ResponseData((Object)voPageInfo);
    }

    @Override
    public ResponseData<MbrTiktokMerchantAuthResultVO> getById(Long mbrTiktokMerchantAuthId) {
        MbrTiktokMerchantAuthPO mbrTiktokMerchantAuthPO = this.mbrTiktokMerchantAuthPOMapper.selectByPrimaryKey(mbrTiktokMerchantAuthId);
        if (null == mbrTiktokMerchantAuthPO) {
            return ResponseUtil.getSuccessData("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        MbrTiktokMerchantAuthResultVO resultVO = new MbrTiktokMerchantAuthResultVO();
        BeanUtils.copyProperties((Object)mbrTiktokMerchantAuthPO, (Object)resultVO);
        return ResponseUtil.getSuccessData(resultVO);
    }

    @Override
    public ResponseData<MbrTiktokMerchantAuthResultVO> getByCondition(MbrTiktokMerchantAuthRequestVO requestVO) {
        MbrTiktokMerchantAuthPOExample poExample = new MbrTiktokMerchantAuthPOExample();
        MbrTiktokMerchantAuthPOExample.Criteria criteria = poExample.createCriteria().andValidEqualTo(1);
        if (requestVO.getSysCompanyId() != null) {
            criteria.andSysCompanyIdEqualTo(requestVO.getSysCompanyId());
        }
        if (requestVO.getSysBrandId() != null) {
            criteria.andSysBrandIdEqualTo(requestVO.getSysBrandId());
        }
        if (StringUtils.isNotBlank((CharSequence)requestVO.getMerchantId())) {
            criteria.andMerchantIdEqualTo(requestVO.getMerchantId());
        }
        poExample.setOrderByClause(" mbr_tiktok_merchant_auth_id desc ");
        List<MbrTiktokMerchantAuthPO> poList = this.mbrTiktokMerchantAuthPOMapper.selectByExample(poExample);
        if (CollectionUtils.isEmpty(poList)) {
            return ResponseUtil.getSuccessData("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        MbrTiktokMerchantAuthResultVO resultVO = new MbrTiktokMerchantAuthResultVO();
        BeanUtils.copyProperties((Object)poList.get(0), (Object)resultVO);
        return ResponseUtil.getSuccessData(resultVO);
    }

    @Override
    public ResponseData<Boolean> save(MbrTiktokMerchantAuthRequestVO requestVO, SysAccountPO sysAccountPO) {
        int row;
        if (requestVO.getMbrTiktokMerchantAuthId() == null) {
            MbrTiktokMerchantAuthPO po = new MbrTiktokMerchantAuthPO();
            BeanUtils.copyProperties((Object)requestVO, (Object)po);
            po.setCreateUserId(sysAccountPO.getSysAccountId());
            po.setCreateUserName(sysAccountPO.getName());
            po.setCreateDate(new Date());
            po.setModifiedUserId(sysAccountPO.getSysAccountId());
            po.setModifiedUserName(sysAccountPO.getName());
            po.setModifiedDate(new Date());
            po.setValid(1);
            row = this.mbrTiktokMerchantAuthPOMapper.insertSelective(po);
        } else {
            MbrTiktokMerchantAuthPO po = new MbrTiktokMerchantAuthPO();
            BeanUtils.copyProperties((Object)requestVO, (Object)po);
            po.setModifiedUserId(sysAccountPO.getSysAccountId());
            po.setModifiedUserName(sysAccountPO.getName());
            po.setModifiedDate(new Date());
            row = this.mbrTiktokMerchantAuthPOMapper.updateByPrimaryKeySelective(po);
        }
        return ResponseUtil.getSuccessData(row > 0);
    }

    @Override
    public ResponseData<String> getDylkAuthUrl(SysAccountPO sysAccountPO) {
        List<String> permissionKeys = Arrays.asList("1", "9", "16");
        String outShopId = "";
        String solutionKey = "4";
        String extra = sysAccountPO.getBrandId().toString();
        String appId = this.systemProperties.getAppId();
        String appSecret = this.systemProperties.getAppSecret();
        log.info("TiktokMerchantAuthConfigServiceImpl-getDylkAuthUrl-info,sysBrandId:{}, appKey:{}, appSecret:{}", new Object[]{sysAccountPO.getBrandId(), appId, appSecret});
        String dylkAuthUrl = GenAuthWithBindUrlUtil.GenAuthWithBindValidUrlFast(appId, appSecret, permissionKeys, outShopId, solutionKey, extra);
        log.info("TiktokMerchantAuthConfigServiceImpl-getDylkAuthUrl-info,dylkAuthUrl:{}", (Object)dylkAuthUrl);
        return new ResponseData((Object)dylkAuthUrl);
    }
}

