/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.service.impl;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.MbrUniversalBindChannelPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api361.WeiMobChannelBindCardService;
import com.bizvane.members.facade.service.common.CommonMemberApiService;
import com.bizvane.members.facade.vo.OpenApiBindCardRequestVo;
import com.bizvane.members.facade.vo.yanzhiwu.MemberThirdBindChannelRequestVo;
import com.bizvane.members.facade.vo.yanzhiwu.ThirdChannelBindQueryRequestVO;
import com.bizvane.openapifacade.models.vo.MemberOpenCard361RequestVo;
import com.bizvane.openapifacade.models.vo.ThirdOpenCardReqVo;
import com.bizvane.openapifacade.rpc.Openapi361Rpc;
import com.bizvane.openapifacade.rpc.ThirdFeignRpc;
import com.bizvane.tiktokmembers.common.constants.TiktokConstants;
import com.bizvane.tiktokmembers.common.enumerations.SystemResponseEnum;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokBusinessConfigRequestVO;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokBusinessConfigResultVO;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokMerchantAuthRequestVO;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokMerchantAuthResultVO;
import com.bizvane.tiktokmembers.common.models.vo.MembersJoinMqRequestVO;
import com.bizvane.tiktokmembers.common.properties.BusinessProperties;
import com.bizvane.tiktokmembers.common.service.OpenOrBindCardCommonMQService;
import com.bizvane.tiktokmembers.common.service.TiktokBusinessConfigService;
import com.bizvane.tiktokmembers.common.service.TiktokMembersJoinService;
import com.bizvane.tiktokmembers.common.service.TiktokMerchantAuthService;
import com.bizvane.tiktokmembers.common.utils.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Api(value="\u6296\u97f3\u4f1a\u5458\u5165\u4f1a\u63a5\u53e3\u5b9e\u73b0\u7c7b", tags={"\u6296\u97f3\u4f1a\u5458\u5165\u4f1a\u63a5\u53e3\u5b9e\u73b0\u7c7b"})
@Service
public class TiktokMembersJoinServiceImpl
implements TiktokMembersJoinService {
    private static final Logger log = LoggerFactory.getLogger(TiktokMembersJoinServiceImpl.class);
    @Autowired
    private TiktokMerchantAuthService tiktokMerchantAuthService;
    @Autowired
    private TiktokBusinessConfigService tiktokBusinessConfigService;
    @Autowired
    private CommonMemberApiService commonMemberApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private Openapi361Rpc openapi361Rpc;
    @Autowired
    private ThirdFeignRpc thirdFeignRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private OpenOrBindCardCommonMQService openOrBindCardCommonMQService;
    @Autowired
    private WeiMobChannelBindCardService weiMobChannelBindCardService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BusinessProperties businessProperties;

    @Override
    public ResponseData<Boolean> membersJoin(MembersJoinMqRequestVO requestVO) {
        String openId = requestVO.getOpenId();
        String mobile = requestVO.getMobile();
        String accountId = requestVO.getAccountId();
        MbrTiktokMerchantAuthRequestVO authRequestVO = new MbrTiktokMerchantAuthRequestVO();
        authRequestVO.setMerchantId(accountId);
        ResponseData<MbrTiktokMerchantAuthResultVO> authRes = this.tiktokMerchantAuthService.getByCondition(authRequestVO);
        log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u5546\u6237\u6388\u6743\u4fe1\u606f,accountId:{}, authRes:{}", (Object)accountId, (Object)JacksonUtil.bean2Json(authRes));
        if (authRes == null || authRes.getCode() != SystemResponseEnum.SUCCESS.getCode().intValue() || authRes.getData() == null) {
            return ResponseUtil.getFailedMsg("\u83b7\u53d6\u5546\u6237\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u5bb6\u6388\u6743\u914d\u7f6e");
        }
        MbrTiktokMerchantAuthResultVO authResultVO = (MbrTiktokMerchantAuthResultVO)authRes.getData();
        if (!Objects.equals(authResultVO.getBindStatus(), 1)) {
            return ResponseUtil.getFailedMsg("\u5546\u6237\u6388\u6743\u5df2\u89e3\u7ed1\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u91cd\u65b0\u6388\u6743");
        }
        Long sysCompanyId = authResultVO.getSysCompanyId();
        Long sysBrandId = authResultVO.getSysBrandId();
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
        if (brandResp == null || brandResp.getCode() != SystemResponseEnum.SUCCESS.getCode().intValue() || brandResp.getData() == null) {
            return ResponseUtil.getFailedMsg("\u83b7\u53d6\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
        }
        SysBrandPo sysBrandPo = (SysBrandPo)brandResp.getData();
        if (!Objects.equals(sysBrandPo.getTiktokMemberSwitch(), true)) {
            return ResponseUtil.getFailedMsg("\u54c1\u724c\u4e0b\u6296\u97f3\u4f1a\u5458\u901a\u7ec4\u4ef6\u670d\u52a1\u5f00\u5173\u672a\u5f00\u542f\uff0c\u6b64\u6b21\u5165\u4f1a\u7533\u8bf7\u4e0d\u5904\u7406");
        }
        MbrTiktokBusinessConfigRequestVO businessConfigRequestVO = new MbrTiktokBusinessConfigRequestVO();
        businessConfigRequestVO.setSysCompanyId(sysCompanyId);
        businessConfigRequestVO.setSysBrandId(sysBrandId);
        businessConfigRequestVO.setBusinessType(1);
        businessConfigRequestVO.setBusinessSwitch(1);
        List<MbrTiktokBusinessConfigResultVO> businessConfigResultVOList = this.tiktokBusinessConfigService.list(businessConfigRequestVO);
        log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u54c1\u724c\u4e0b\u6296\u97f3\u4f1a\u5458\u901a\u670d\u52a1\u914d\u7f6e\u5217\u8868\uff0csysBrandId:{}, businessConfigResultVOList:{}", (Object)sysBrandId, (Object)JacksonUtil.list2Json(businessConfigResultVOList));
        if (CollectionUtils.isEmpty(businessConfigResultVOList)) {
            return ResponseUtil.getFailedMsg("\u54c1\u724c\u4e0b\u6296\u97f3\u4f1a\u5458\u901a\u5165\u4f1a\u670d\u52a1\u5f00\u5173\u672a\u5f00\u542f\uff0c\u6b64\u6b21\u5165\u4f1a\u7533\u8bf7\u4e0d\u5904\u7406");
        }
        ThirdChannelBindQueryRequestVO thirdChannelBindQueryRequestVO = new ThirdChannelBindQueryRequestVO();
        thirdChannelBindQueryRequestVO.setChannelType(TiktokConstants.TIKTOK_CHANNEL_TYPE);
        thirdChannelBindQueryRequestVO.setOpenId(openId);
        thirdChannelBindQueryRequestVO.setSysCompanyId(sysCompanyId);
        thirdChannelBindQueryRequestVO.setSysBrandId(sysBrandId);
        ResponseData bindChannelPoRes = this.commonMemberApiService.selectMbrUniversalBindChannelByOpenId(thirdChannelBindQueryRequestVO);
        log.info("TiktokMembersJoinServiceImpl-membersJoin-info,bindChannelPoRes:{}", (Object)JacksonUtil.bean2Json((Object)bindChannelPoRes));
        if (null == bindChannelPoRes || SysResponseEnum.SUCCESS.getCode() != bindChannelPoRes.getCode()) {
            log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u67e5\u8be2\u6839\u636eopenId\u67e5\u8be2\u4f1a\u5458\u6296\u97f3\u7ed1\u5361\u6e20\u9053\u5931\u8d25");
            return ResponseUtil.getFailedData("\u67e5\u8be2\u6839\u636eopenId\u67e5\u8be2\u4f1a\u5458\u6296\u97f3\u7ed1\u5361\u6e20\u9053\u5931\u8d25");
        }
        MemberInfoModel memberInfoModel = null;
        Boolean isNewMember = false;
        List bindChannelPoList = (List)bindChannelPoRes.getData();
        if (CollectionUtils.isEmpty((Collection)bindChannelPoList)) {
            memberInfoModel = this.getMemberInfoModelByPhone(sysCompanyId, sysBrandId, mobile);
            if (memberInfoModel == null) {
                log.info("TiktokMembersJoinServiceImpl-membersJoin-info,openId\u65e0\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4e14\u624b\u673a\u53f7\u5728\u4f1a\u5458\u8868\u4e0d\u5b58\u5728\uff0c\u8d70\u6296\u97f3\u4f1a\u5458\u901a\u6e20\u9053\u5f00\u5361\u6d41\u7a0b\uff0c\u4f7f\u7528openId\u548c\u624b\u673a\u53f7\u65b0\u589e1\u6761\u6296\u97f3\u6e20\u9053\u8bb0\u5f55,mobile:{}", (Object)mobile);
                ResponseData responseData = this.openCard(requestVO, authResultVO);
                if (null == responseData || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                    return ResponseUtil.getFailedData("\u624b\u673a\u53f7[" + mobile + "]\u5f00\u5361\u5931\u8d25");
                }
                isNewMember = true;
            } else if (Objects.equals(memberInfoModel.getOpenCardChannelId(), Long.valueOf(TiktokConstants.TIKTOK_CHANNEL_ID.toString()))) {
                log.info("TiktokMembersJoinServiceImpl-membersJoin-info,openId\u65e0\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4f46\u624b\u673a\u53f7\u5728\u4f1a\u5458\u8868\u4e2d\u5b58\u5728\uff0c\u5f00\u5361\u6e20\u9053\u4e3a\u6296\u97f3\uff0c\u5219\u4f7f\u7528openId\u548c\u624b\u673a\u53f7\u65b0\u589e1\u6761\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4e0d\u8d70\u7ed1\u5361\u6d41\u7a0b,mobile:{}", (Object)mobile);
                this.saveChannelRecord(requestVO, authResultVO, memberInfoModel.getMemberCode(), Boolean.FALSE);
            } else {
                log.info("TiktokMembersJoinServiceImpl-membersJoin-info,openId\u65e0\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4f46\u624b\u673a\u53f7\u5728\u4f1a\u5458\u8868\u4e2d\u5b58\u5728\uff0c\u5f00\u5361\u6e20\u9053\u975e\u6296\u97f3\uff0c\u5219\u4f7f\u7528openId\u548c\u624b\u673a\u53f7\u65b0\u589e1\u6761\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u8d70\u7ed1\u5361\u6d41\u7a0b,mobile:{}", (Object)mobile);
                ResponseData responseData = this.bingCard(requestVO, authResultVO);
            }
        } else {
            List memberCodeExistList = bindChannelPoList.stream().map(MbrUniversalBindChannelPo::getMemberCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(memberCodeExistList)) {
                memberInfoModel = this.getMemberInfoModelByPhone(sysCompanyId, sysBrandId, mobile);
                if (memberInfoModel == null) {
                    log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u6709\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4f46openId\u672a\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u624b\u673a\u53f7\u5728\u4f1a\u5458\u8868\u4e5f\u4e0d\u5b58\u5728\uff0c\u8d70\u6296\u97f3\u4f1a\u5458\u901a\u6e20\u9053\u5f00\u5361\u6d41\u7a0b\uff0c\u4f7f\u7528openId\u548c\u624b\u673a\u53f7\u65b0\u589e1\u6761\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u8d70\u5f00\u5361\u6d41\u7a0b,mobile:{}", (Object)mobile);
                    ResponseData responseData = this.openCard(requestVO, authResultVO);
                    if (null == responseData || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                        return ResponseUtil.getFailedData("\u624b\u673a\u53f7[" + mobile + "]\u5f00\u5361\u5931\u8d25");
                    }
                    isNewMember = true;
                } else {
                    log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u6709\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0c\u4f46openId\u672a\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u624b\u673a\u53f7\u5728\u4f1a\u5458\u8868\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6e20\u9053\u8868openId\u548c\u4f1a\u5458Code\u5173\u7cfb,mobile:{}", (Object)mobile);
                    this.updateChannelRecord(requestVO, authResultVO, (String)memberCodeExistList.get(0), Boolean.FALSE);
                }
            } else {
                MemberInfoModel memberCodeExistModel = this.getMemberInfoModelByMemberCode(sysCompanyId, sysBrandId, (String)memberCodeExistList.get(0));
                if (memberCodeExistModel == null) {
                    log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u6709\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0copenId\u5df2\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u4f46\u7ed1\u5b9a\u7684\u4f1a\u5458Code\u672a\u5728\u4f1a\u5458\u8868\u627e\u5230\u8bb0\u5f55\uff0c\u8d70\u5f00\u5361\u6d41\u7a0b,mobile:{}", (Object)mobile);
                    ResponseData responseData = this.openCard(requestVO, authResultVO);
                    if (null == responseData || SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                        return ResponseUtil.getFailedData("\u624b\u673a\u53f7[" + mobile + "]\u5f00\u5361\u5931\u8d25");
                    }
                    isNewMember = true;
                } else if (!Objects.equals(memberCodeExistModel.getPhone(), mobile)) {
                    log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u6709\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0copenId\u5df2\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u5165\u4f1a\u624b\u673a\u53f7\u4e0eCRM\u624b\u673a\u53f7\u4e0d\u76f8\u540c\uff0c\u5165\u4f1a\u5931\u8d25,mobile:{}", (Object)mobile);
                    return ResponseUtil.getFailedMsg("\u624b\u673a\u53f7[" + mobile + "]openId\u5df2\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u4f46\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u548c\u672c\u6b21\u6296\u97f3\u4f1a\u5458\u5165\u4f1a\u4e0d\u4e00\u81f4\uff0c\u5165\u4f1a\u5931\u8d25");
                }
                log.info("TiktokMembersJoinServiceImpl-membersJoin-info,\u6709\u6296\u97f3\u6e20\u9053\u8bb0\u5f55\uff0copenId\u5df2\u7ed1\u5b9acrm\u4f1a\u5458Code\uff0c\u5165\u4f1a\u624b\u673a\u53f7\u4e0eCRM\u624b\u673a\u53f7\u76f8\u540c\uff0c\u5165\u4f1a\u6210\u529f,mobile:{}", (Object)mobile);
            }
        }
        return ResponseUtil.getSuccessData(isNewMember, "\u624b\u673a\u53f7[" + mobile + "]\u6296\u97f3\u4f1a\u5458\u5165\u4f1a\u6210\u529f");
    }

    private MemberInfoModel getMemberInfoModelByPhone(Long sysCompanyId, Long sysBrandId, String phone) {
        MemberInfoModel searchModel = MemberInfoModel.builder().phone(phone).sysCompanyId(sysCompanyId).brandId(sysBrandId).build();
        log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByPhone-info,phone:{}", (Object)phone);
        ResponseData memberInfoResp = this.memberInfoApiService.getSingleMemberModel(searchModel);
        log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByPhone-info,memberInfoResp:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoResp));
        if (null == memberInfoResp || SysResponseEnum.SUCCESS.getCode() != memberInfoResp.getCode()) {
            log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByPhone-info,\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u4f1a\u5458\u5931\u8d25\uff0cphone:{}", (Object)phone);
            return null;
        }
        return (MemberInfoModel)memberInfoResp.getData();
    }

    private MemberInfoModel getMemberInfoModelByMemberCode(Long sysCompanyId, Long sysBrandId, String memberCode) {
        MemberInfoModel searchModel = MemberInfoModel.builder().memberCode(memberCode).sysCompanyId(sysCompanyId).brandId(sysBrandId).build();
        log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByMemberCode-info,memberCode:{}", (Object)memberCode);
        ResponseData memberInfoResp = this.memberInfoApiService.getSingleMemberModel(searchModel);
        log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByMemberCode-info,memberInfoResp:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoResp));
        if (null == memberInfoResp || SysResponseEnum.SUCCESS.getCode() != memberInfoResp.getCode()) {
            log.info("TiktokMembersJoinServiceImpl-getMemberInfoModelByMemberCode-info,\u6839\u636e\u4f1a\u5458Code\u67e5\u8be2\u4f1a\u5458\u5931\u8d25\uff0cmemberCode:{}", (Object)memberCode);
            return null;
        }
        return (MemberInfoModel)memberInfoResp.getData();
    }

    private ResponseData openCard(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO) {
        log.info("TiktokMembersJoinServiceImpl-openCard-info,membersJoinSysCompanyId361List:{},membersJoinSysCompanyIdThirdList:{}", this.businessProperties.getMembersJoinSysCompanyId361List(), this.businessProperties.getMembersJoinSysCompanyIdThirdList());
        ResponseData responseData = new ResponseData();
        Long sysCompanyId = authResultVO.getSysCompanyId();
        if (this.businessProperties.getMembersJoinSysCompanyId361List().contains(sysCompanyId)) {
            responseData = this.openCard361(membersJoinMqRequestVO, authResultVO);
        } else if (this.businessProperties.getMembersJoinSysCompanyIdThirdList().contains(sysCompanyId)) {
            // empty if block
        }
        return responseData;
    }

    private ResponseData openCard361(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO) {
        log.info("TiktokMembersJoinServiceImpl-openCard361-info,\u8fdb\u884c\u5f00\u5361\u6d41\u7a0b\uff0cmobile:{},openId:{}", (Object)membersJoinMqRequestVO.getMobile(), (Object)membersJoinMqRequestVO.getOpenId());
        ResponseData responseData = new ResponseData();
        String openCardKey = "tiktokMembersBase:openCard:" + authResultVO.getSysBrandId() + "_" + membersJoinMqRequestVO.getMobile();
        Boolean lockAcquired = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)openCardKey, (Object)membersJoinMqRequestVO.getMobile());
        if (lockAcquired != null && !lockAcquired.booleanValue()) {
            log.info("TiktokMembersJoinServiceImpl-openCard361-info,\u5f53\u524d\u624b\u673a\u53f7\u6ce8\u518c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42:{},\u54c1\u724cID:{}", (Object)membersJoinMqRequestVO.getMobile(), (Object)authResultVO.getSysBrandId());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)Boolean.FALSE);
            responseData.setMessage("\u5f53\u524d\u624b\u673a\u53f7\u6ce8\u518c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u8bf7\u6c42");
            return responseData;
        }
        this.stringRedisTemplate.opsForValue().set((Object)openCardKey, (Object)membersJoinMqRequestVO.getMobile(), (long)TiktokConstants.REDIS_OPEN_CARD_LOCK_TIME.intValue(), TimeUnit.SECONDS);
        String mobile = membersJoinMqRequestVO.getMobile();
        String openId = membersJoinMqRequestVO.getOpenId();
        Long sysCompanyId = authResultVO.getSysCompanyId();
        Long sysBrandId = authResultVO.getSysBrandId();
        String sysStoreOnlineCode = authResultVO.getSysStoreOnlineCode();
        String staffCode = authResultVO.getStaffCode();
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
        if (brandResp == null || brandResp.getCode() != SystemResponseEnum.SUCCESS.getCode().intValue() || brandResp.getData() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u83b7\u53d6\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            return responseData;
        }
        MemberOpenCard361RequestVo openCardRequestVo = new MemberOpenCard361RequestVo();
        openCardRequestVo.setSysCompanyId(sysCompanyId);
        openCardRequestVo.setBrandCode(((SysBrandPo)brandResp.getData()).getBrandCode());
        openCardRequestVo.setPhone(mobile);
        openCardRequestVo.setRegisterType(TiktokConstants.TIKTOK_CHANNEL_TYPE);
        openCardRequestVo.setSourceCode("$biz_tiktok_organic_traffic");
        openCardRequestVo.setThirdOpenId(openId);
        openCardRequestVo.setSex(Integer.valueOf(3));
        openCardRequestVo.setStoreCode(sysStoreOnlineCode);
        openCardRequestVo.setStaffCode(staffCode);
        openCardRequestVo.setValid(Integer.valueOf(1));
        log.info("TiktokMembersJoinServiceImpl-openCard361-info,openCard request:{}", (Object)JacksonUtil.bean2Json((Object)openCardRequestVo));
        ResponseData openCardRes = this.openapi361Rpc.openCard(openCardRequestVo);
        log.info("TiktokMembersJoinServiceImpl-openCard361-info,openCard mobile:{},result:{}", (Object)mobile, (Object)JacksonUtil.bean2Json((Object)openCardRes));
        return openCardRes;
    }

    private ResponseData openCardThird(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO) {
        log.info("TiktokMembersJoinServiceImpl-openCardThird-info,\u8fdb\u884c\u5f00\u5361\u6d41\u7a0b\uff0cmobile:{},openId:{}", (Object)membersJoinMqRequestVO.getMobile(), (Object)membersJoinMqRequestVO.getOpenId());
        ResponseData responseData = new ResponseData();
        String openCardKey = "tiktokMembersBase:openCard:" + authResultVO.getSysBrandId() + "_" + membersJoinMqRequestVO.getMobile();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.stringRedisTemplate.opsForValue().get((Object)openCardKey)))) {
            log.info("TiktokMembersJoinServiceImpl-openCardThird-info,\u5f53\u524d\u624b\u673a\u53f7\u6ce8\u518c\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5:{},\u54c1\u724cID:{}", (Object)membersJoinMqRequestVO.getMobile(), (Object)authResultVO.getSysBrandId());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5f53\u524d\u624b\u673a\u53f7\u6ce8\u518c\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return responseData;
        }
        this.stringRedisTemplate.opsForValue().set((Object)openCardKey, (Object)membersJoinMqRequestVO.getMobile(), (long)TiktokConstants.REDIS_OPEN_CARD_LOCK_TIME.intValue(), TimeUnit.SECONDS);
        String mobile = membersJoinMqRequestVO.getMobile();
        String openId = membersJoinMqRequestVO.getOpenId();
        Long sysCompanyId = authResultVO.getSysCompanyId();
        Long sysBrandId = authResultVO.getSysBrandId();
        String sysStoreOnlineCode = authResultVO.getSysStoreOnlineCode();
        String staffCode = authResultVO.getStaffCode();
        ThirdOpenCardReqVo openCardRequestVo = new ThirdOpenCardReqVo();
        openCardRequestVo.setSysCompanyId(sysCompanyId);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
        openCardRequestVo.setBrandCode(((SysBrandPo)brandResp.getData()).getBrandCode());
        openCardRequestVo.setPhone(mobile);
        openCardRequestVo.setSex(Integer.valueOf(3));
        openCardRequestVo.setSource(TiktokConstants.TIKTOK_CHANNEL_TYPE);
        openCardRequestVo.setStoreCode(sysStoreOnlineCode);
        openCardRequestVo.setGuideCode(staffCode);
        log.info("TiktokMembersJoinServiceImpl-openCardThird-info,openCard request:{}", (Object)JacksonUtil.bean2Json((Object)openCardRequestVo));
        ResponseData openCardRes = this.thirdFeignRpc.openCard(openCardRequestVo);
        log.info("TiktokMembersJoinServiceImpl-openCardThird-info,openCard mobile:{},result:{}", (Object)mobile, (Object)JacksonUtil.bean2Json((Object)openCardRes));
        return openCardRes;
    }

    private ResponseData bingCard(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO) {
        log.info("TiktokMembersJoinServiceImpl-bingCard-info,\u8fdb\u884c\u7ed1\u5361\u6d41\u7a0b\uff0cmobile:{},openId:{}", (Object)membersJoinMqRequestVO.getMobile(), (Object)membersJoinMqRequestVO.getOpenId());
        ResponseData responseData = new ResponseData();
        Long sysCompanyId = authResultVO.getSysCompanyId();
        if (this.businessProperties.getMembersJoinSysCompanyId361List().contains(sysCompanyId)) {
            responseData = this.bindCard361(membersJoinMqRequestVO, authResultVO);
        } else if (this.businessProperties.getMembersJoinSysCompanyIdThirdList().contains(sysCompanyId)) {
            // empty if block
        }
        log.info("TiktokMembersJoinServiceImpl-bingCard-info,\u7ed1\u5361\u5b8c\u6210\u6d41\u7a0b\u7ed3\u679c\uff0cmobile:{}", (Object)membersJoinMqRequestVO.getMobile());
        return responseData;
    }

    private ResponseData bindCard361(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO) {
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(authResultVO.getSysBrandId());
        OpenApiBindCardRequestVo requestVo = new OpenApiBindCardRequestVo();
        requestVo.setSource(TiktokConstants.TIKTOK_CHANNEL_TYPE);
        requestVo.setBrandCode(((SysBrandPo)brandResp.getData()).getBrandCode());
        requestVo.setPhone(membersJoinMqRequestVO.getMobile());
        requestVo.setSysCompanyId(authResultVO.getSysCompanyId());
        requestVo.setSourceCode("$biz_tiktok_organic_traffic");
        requestVo.setThirdOpenId(membersJoinMqRequestVO.getOpenId());
        log.info("TiktokMembersJoinServiceImpl-bindCard361-info,requestVo:{}", (Object)JacksonUtil.bean2Json((Object)requestVo));
        ResponseData responseData = this.weiMobChannelBindCardService.bindCard(requestVo);
        log.info("TiktokMembersJoinServiceImpl-bindCard361-info,responseData:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    private void saveChannelRecord(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO, String memberCode, Boolean openCardChannel) {
        MemberThirdBindChannelRequestVo bindChannelRequestVo = MemberThirdBindChannelRequestVo.builder().memberCode(memberCode).sysCompanyId(authResultVO.getSysCompanyId()).brandId(authResultVO.getSysBrandId()).bindTime(new Date()).channelOpenCard(openCardChannel).bindType(TiktokConstants.UNIVERSAL_BIND_TYPE_BIND).channelType(TiktokConstants.TIKTOK_CHANNEL_TYPE).nick("").gender("3").openId(membersJoinMqRequestVO.getOpenId()).build();
        log.info("TiktokMembersJoinServiceImpl-saveChannelRecord-info,request:{}", (Object)JacksonUtil.bean2Json((Object)bindChannelRequestVo));
        ResponseData responseData = this.commonMemberApiService.memberThirdBindChannel(bindChannelRequestVo);
        log.info("TiktokMembersJoinServiceImpl-saveChannelRecord-info,result:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
    }

    private void updateChannelRecord(MembersJoinMqRequestVO membersJoinMqRequestVO, MbrTiktokMerchantAuthResultVO authResultVO, String memberCode, Boolean openCardChannel) {
        MemberThirdBindChannelRequestVo bindChannelRequestVo = MemberThirdBindChannelRequestVo.builder().memberCode(memberCode).bindType(TiktokConstants.UNIVERSAL_BIND_TYPE_BIND).bindTime(new Date()).channelOpenCard(openCardChannel).sysCompanyId(authResultVO.getSysCompanyId()).brandId(authResultVO.getSysBrandId()).openId(membersJoinMqRequestVO.getOpenId()).build();
        log.info("TiktokMembersJoinServiceImpl-updateChannelRecord-info,request:{}", (Object)JacksonUtil.bean2Json((Object)bindChannelRequestVo));
        ResponseData responseData = this.commonMemberApiService.updateMbrUniversalBindChannelByCondition(bindChannelRequestVo);
        log.info("TiktokMembersJoinServiceImpl-updateChannelRecord-info,result:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
    }
}

