/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.service.impl;

import com.bizvane.tiktokmembers.common.mapper.MbrTiktokBusinessConfigPOMapper;
import com.bizvane.tiktokmembers.common.models.po.MbrTiktokBusinessConfigPO;
import com.bizvane.tiktokmembers.common.models.po.MbrTiktokBusinessConfigPOExample;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokBusinessConfigRequestVO;
import com.bizvane.tiktokmembers.common.models.vo.MbrTiktokBusinessConfigResultVO;
import com.bizvane.tiktokmembers.common.service.TiktokBusinessConfigService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Api(value="\u6296\u97f3\u4f1a\u5458\u901a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0\u7c7b", tags={"\u6296\u97f3\u4f1a\u5458\u901a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0\u7c7b"})
@Service
public class TiktokBusinessConfigServiceImpl
implements TiktokBusinessConfigService {
    private static final Logger log = LoggerFactory.getLogger(TiktokBusinessConfigServiceImpl.class);
    @Autowired
    private MbrTiktokBusinessConfigPOMapper mbrTiktokBusinessConfigPOMapper;

    @Override
    public List<MbrTiktokBusinessConfigResultVO> list(MbrTiktokBusinessConfigRequestVO requestVO) {
        MbrTiktokBusinessConfigPOExample poExample = new MbrTiktokBusinessConfigPOExample();
        MbrTiktokBusinessConfigPOExample.Criteria criteria = poExample.createCriteria();
        criteria.andSysCompanyIdEqualTo(requestVO.getSysCompanyId()).andSysBrandIdEqualTo(requestVO.getSysBrandId()).andValidEqualTo(1);
        if (requestVO.getBusinessType() != null) {
            criteria.andBusinessTypeEqualTo(requestVO.getBusinessType());
        }
        if (requestVO.getBusinessSwitch() != null) {
            criteria.andBusinessSwitchEqualTo(requestVO.getBusinessSwitch());
        }
        poExample.setOrderByClause(" mbr_tiktok_business_config_id desc ");
        List<MbrTiktokBusinessConfigPO> poList = this.mbrTiktokBusinessConfigPOMapper.selectByExample(poExample);
        if (CollectionUtils.isEmpty(poList)) {
            return new ArrayList<MbrTiktokBusinessConfigResultVO>();
        }
        List<MbrTiktokBusinessConfigResultVO> voList = poList.stream().map(item -> {
            MbrTiktokBusinessConfigResultVO resultVO = new MbrTiktokBusinessConfigResultVO();
            BeanUtils.copyProperties((Object)item, (Object)resultVO);
            return resultVO;
        }).collect(Collectors.toList());
        return voList;
    }
}

