/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.service.impl;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.tiktokmembers.common.service.OpenOrBindCardCommonMQService;
import com.bizvane.tiktokmembers.common.utils.DateUtil;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.rocketutils.RocketMQClient;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Api(value="\u5f00\u7ed1\u5361\u53d1\u9001MQ\u5b9e\u73b0\u7c7b", tags={"\u5f00\u7ed1\u5361\u53d1\u9001MQ\u5b9e\u73b0\u7c7b"})
@Service
public class OpenOrBindCardCommonMQServiceImpl
implements OpenOrBindCardCommonMQService {
    private static final Logger log = LoggerFactory.getLogger(OpenOrBindCardCommonMQServiceImpl.class);
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private RocketMQClient rocketMqClient;

    @Override
    public void sendOpenCard2MQMessage(MemberInfoModel memberInfoModel) {
        log.info("OpenOrBindCardCommonMQServiceImpl-sendOpenCard2MQMessage-info,memberInfoModel:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        if (null == memberInfoModel) {
            return;
        }
        Message message = new Message();
        PushMbrModel pushMbrModel = this.createPushMbrModel(memberInfoModel, 2);
        log.info("OpenOrBindCardCommonMQServiceImpl-sendOpenCard2MQMessage-info,pushMbrModel:{}", (Object)JacksonUtil.bean2Json((Object)pushMbrModel));
        message.setBody(JacksonUtil.bean2Json((Object)pushMbrModel).getBytes());
        message.setTopic("public_member_register_message");
        message.setTag("regist");
        this.push(message);
    }

    @Override
    public void sendBindCard2MQMessage(MemberInfoModel memberInfoModel) {
        log.info("OpenOrBindCardCommonMQServiceImpl-sendBindCard2MQMessage-info,memberInfoModel:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        if (null == memberInfoModel) {
            return;
        }
        Message message = new Message();
        PushMbrModel pushMbrModel = this.createPushMbrModel(memberInfoModel, 1);
        log.info("OpenOrBindCardCommonMQServiceImpl-sendBindCard2MQMessage-info,pushMbrModel:{}", (Object)JacksonUtil.bean2Json((Object)pushMbrModel));
        message.setBody(JacksonUtil.bean2Json((Object)pushMbrModel).getBytes());
        message.setTopic("public_member_bind_message");
        message.setTag("bind");
        this.push(message);
    }

    private PushMbrModel createPushMbrModel(MemberInfoModel memberInfoModel, Integer operateType) {
        return PushMbrModel.builder().sysCompanyId(memberInfoModel.getSysCompanyId()).brandId(memberInfoModel.getBrandId()).memberCode(memberInfoModel.getMemberCode()).unionId(memberInfoModel.getWxUnionId()).openId(memberInfoModel.getWxOpenId()).address(memberInfoModel.getAddress()).erpId(memberInfoModel.getErpId()).name(memberInfoModel.getName()).gender(memberInfoModel.getGender()).phone(memberInfoModel.getPhone()).email(memberInfoModel.getEmail()).idCard(memberInfoModel.getIdCard()).birthday(memberInfoModel.getBirthday()).birthdayMd(memberInfoModel.getBirthdayMd()).province(memberInfoModel.getProvince()).city(memberInfoModel.getCity()).county(memberInfoModel.getCounty()).address(memberInfoModel.getAddress()).headPortraits(memberInfoModel.getHeadPortraits()).barCode(memberInfoModel.getBarCode()).cardStatus(memberInfoModel.getCardStatus()).cardUseStatus(memberInfoModel.getCardUseStatus()).valid(memberInfoModel.getValid()).openCardTime(memberInfoModel.getOpenCardTime()).bindCardTime(memberInfoModel.getBindCardTime()).inviteRegisterTime(DateUtil.dateFormatStr(memberInfoModel.getOpenCardTime(), DateUtil.ymdhms)).effectiveTime(memberInfoModel.getEffectiveTime()).levelId(memberInfoModel.getLevelId()).levelName(memberInfoModel.getLevelName()).cardNo(memberInfoModel.getCardNo()).offlineCardNo(memberInfoModel.getOfflineCardNo()).storesName(this.getSoreName(memberInfoModel.getServiceStoreId())).serviceStoreId(memberInfoModel.getServiceStoreId()).openCardGuideId(memberInfoModel.getOpenCardGuideId()).serviceGuideId(memberInfoModel.getServiceGuideId()).openCardStoreId(memberInfoModel.getOpenCardStoreId()).operateType(operateType).sceneId(null).sceneValue(null).sourceWay(null).offlineCompanyCode(memberInfoModel.getOfflineCompanyCode()).offlineBrandCode(memberInfoModel.getOfflineBrandCode()).openCardStoreCode(memberInfoModel.getOpenCardStoreCode()).openCardGuideCode(memberInfoModel.getOpenCardGuideCode()).serviceStoreCode(memberInfoModel.getServiceStoreCode()).serviceGuideCode(memberInfoModel.getServiceGuideCode()).offlineLevelCode(memberInfoModel.getOfflineLevelCode()).activeStore(memberInfoModel.getActiveStore()).countIntegral(memberInfoModel.getCountIntegral()).addUpIntegral(memberInfoModel.getAddUpIntegral()).offlineUpdateDate(memberInfoModel.getOfflineUpdateDate()).pastDueIntegral(memberInfoModel.getPastDueIntegral()).consumeIntegral(memberInfoModel.getConsumeIntegral()).freezeIntegral(memberInfoModel.getFreezeIntegral()).offlineUpdateIntegralDate(memberInfoModel.getOfflineUpdateIntegralDate()).balance(memberInfoModel.getBalance()).babyBirthday(memberInfoModel.getBabyBirthday()).babyBirthdayMd(memberInfoModel.getBabyBirthdayMd()).petCard(memberInfoModel.getPetCard()).offlineUpdateBalanceDate(memberInfoModel.getOfflineUpdateBalanceDate()).registerType(memberInfoModel.getRegisterType()).emailStatus(memberInfoModel.getEmailStatus()).firstLandingCheck(memberInfoModel.getFirstLandingCheck()).masterBrandId(null).memberElectCardCode(memberInfoModel.getMemberElectCardCode()).build();
    }

    private String getSoreName(Long getServiceStoreId) {
        SysStoreVo storeVo;
        String storeName = "";
        if (getServiceStoreId != null && getServiceStoreId != 0L && (storeVo = (SysStoreVo)this.storeServiceRpc.getSysStoreById(getServiceStoreId).getData()) != null) {
            storeName = storeVo.getStoreName();
        }
        return storeName;
    }

    private void push(Message message) {
        try {
            SendResult sendResult = this.rocketMqClient.sendMessage(message);
            if (null == sendResult) {
                log.error("OpenOrBindCardCommonMQServiceImpl-push-info,\u5f00\u7ed1\u5361\u53d1\u9001MQ\u8fd4\u56de\u4e3a\u7a7a,\u63a8\u9001mq\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            log.error("OpenOrBindCardCommonMQServiceImpl-push-info,\u5f00\u7ed1\u5361\u53d1\u9001MQ\u6d88\u606f\u5931\u8d25\uff01{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

