/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.tiktokmembers.common.config.DouYinConfig;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DouYinTokenService {
    private static final Logger log = LoggerFactory.getLogger(DouYinTokenService.class);
    private static final String REDIS_KEY_PREFIX = "com:bizvane:douyin:access_token:";
    private static final long TOKEN_EXPIRE_SECONDS = 6900L;
    @Resource
    private DouYinConfig douYinConfig;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private RestTemplate restTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        Boolean locked;
        String clientKey = this.douYinConfig.getClientKey();
        String tokenKey = "com:bizvane:douyin:access_token::" + clientKey;
        String lockKey = "com:bizvane:douyin:access_token::" + clientKey + ":lock";
        String lockValue = String.valueOf(System.nanoTime());
        String tokenJson = (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
        if (tokenJson != null) {
            TokenInfo tokenInfo = this.parseTokenInfo(tokenJson);
            return tokenInfo.access_token;
        }
        int retryCount = 0;
        int maxRetries = 5;
        while (retryCount < maxRetries && !Boolean.TRUE.equals(locked = (Boolean)this.redisTemplate.execute(connection -> connection.set(lockKey.getBytes(), lockValue.getBytes(), Expiration.from((long)15L, (TimeUnit)TimeUnit.SECONDS), RedisStringCommands.SetOption.SET_IF_ABSENT), true))) {
            ++retryCount;
            try {
                Thread.sleep(100L * (long)retryCount);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((tokenJson = (String)this.redisTemplate.opsForValue().get((Object)tokenKey)) == null) continue;
            TokenInfo tokenInfo = this.parseTokenInfo(tokenJson);
            return tokenInfo.access_token;
        }
        if (retryCount >= maxRetries) {
            log.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\u5df2\u8fbe\u6700\u5927\u503c\uff0c\u83b7\u53d6\u6296\u97f3AccessToken\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6296\u97f3\u914d\u7f6e\u6216\u7f51\u7edc\u8fde\u63a5");
            return null;
        }
        try {
            tokenJson = (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
            if (tokenJson != null) {
                TokenInfo tokenInfo = this.parseTokenInfo(tokenJson);
                String string = tokenInfo.access_token;
                return string;
            }
            TokenInfo newToken = this.fetchNewToken();
            if (null == newToken) {
                String string = null;
                return string;
            }
            String tokenInfoJson = this.toJson(newToken);
            this.redisTemplate.opsForValue().set((Object)tokenKey, (Object)tokenInfoJson, 6900L, TimeUnit.SECONDS);
            String string = newToken.access_token;
            return string;
        }
        finally {
            String currentLockValue = (String)this.redisTemplate.opsForValue().get((Object)lockKey);
            if (lockValue.equals(currentLockValue)) {
                this.redisTemplate.delete((Object)lockKey);
            }
        }
    }

    private TokenInfo fetchNewToken() {
        try {
            ResponseEntity response;
            String clientKey = this.douYinConfig.getClientKey();
            String clientSecret = this.douYinConfig.getClientSecret();
            String apiUrl = this.douYinConfig.getApiUrl();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("grant_type", "client_credential");
            body.put("client_key", clientKey);
            body.put("client_secret", clientSecret);
            HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
            try {
                log.info("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u5f00\u59cb,apiUrl={},client_key={} ", (Object)apiUrl, (Object)clientKey);
                response = this.restTemplate.postForEntity(apiUrl, (Object)requestEntity, String.class, new Object[0]);
                log.info("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u7ed3\u675f,apiUrl={},client_key={} ,response={}", new Object[]{apiUrl, clientKey, JacksonUtil.bean2Json((Object)response)});
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
            if (!response.getStatusCode().is2xxSuccessful()) {
                log.info("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u5931\u8d25:response StatusCode is not 2xx, statusCode={}", (Object)response.getStatusCode());
                return null;
            }
            String responseBody = (String)response.getBody();
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            JSONObject data = jsonObject.getJSONObject("data");
            if (data == null) {
                log.info("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u5931\u8d25:response data is null");
                return null;
            }
            long errorCode = data.getLongValue("error_code");
            if (errorCode != 0L) {
                log.info("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u5931\u8d25:errorCode={},description={}", (Object)errorCode, (Object)data.getString("description"));
                return null;
            }
            return this.parseTokenInfo(data.toJSONString());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6296\u97f3\u63a5\u53e3\u83b7\u53d6token\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private TokenInfo parseTokenInfo(String json) {
        return (TokenInfo)JSONObject.parseObject((String)json, TokenInfo.class);
    }

    private String toJson(TokenInfo tokenInfo) {
        return JSONObject.toJSONString((Object)tokenInfo);
    }

    public static class TokenInfo {
        String access_token;
        long expires_in;

        public String getAccess_token() {
            return this.access_token;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public long getExpires_in() {
            return this.expires_in;
        }

        public void setExpires_in(long expires_in) {
            this.expires_in = expires_in;
        }
    }
}

