/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tiktokmembers.common.config;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ResponseDataHandleAspect {
    private static final Logger log = LoggerFactory.getLogger(ResponseDataHandleAspect.class);
    private final String ASPECT = "@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)";

    @Around(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public Object checkAndExceptionHandle(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = null;
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            request = attributes.getRequest();
            log.info("REQUEST START | {} URL : {}, ARGS : {}", new Object[]{request.getMethod(), request.getRequestURI().toString(), JacksonUtil.bean2Json(Arrays.asList(pjp.getArgs()))});
            log.info("CLASS_METHOD : {}", (Object)(pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName()));
        }
        catch (Exception e) {
            log.info("checkAndExceptionHandle exception: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        Signature signature = pjp.getSignature();
        Class returnType = ((MethodSignature)signature).getReturnType();
        if (!returnType.isAssignableFrom(ResponseData.class)) {
            return pjp.proceed();
        }
        ResponseData result = new ResponseData();
        try {
            result = (ResponseData)pjp.proceed();
            if (result.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                result.setCode(SysResponseEnum.SUCCESS.getCode());
                result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            }
        }
        catch (Exception e) {
            this.dealException((ResponseData<Object>)result, e);
        }
        log.info("END | {} RESPONSE : {}", (Object)request.getRequestURI().toString(), (Object)JacksonUtil.bean2Json((Object)result));
        return result;
    }

    private void dealException(ResponseData<Object> result, Exception e) {
        if (e instanceof BizException) {
            result.setCode(((BizException)e).getCode());
            result.setMessage(((BizException)e).getMessage());
            log.info("BusinessException: {}", (Object)((BizException)e).getCode());
            log.info("BusinessException: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        } else {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.FAILED.getMessage());
            log.error("ERROR:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

