/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.sun.v1.common.Data;
import com.bizvane.sun.v1.common.ValueType;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class MapUtil {
    public static Object getObject(Map<String, Data> map, String key) {
        for (Map.Entry<String, Data> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Data getData(Map<String, Data> map, String key) {
        return (Data)MapUtil.getObject(map, key);
    }

    public static String getParam(Map<String, Data> map, String key) {
        Data data = MapUtil.getData(map, key);
        if (data != null && data.type == ValueType.PARAM) {
            return data.value;
        }
        return null;
    }

    public static String getJSONString(Map<String, Data> map, String key) {
        Data data = MapUtil.getData(map, key);
        if (data != null && data.type == ValueType.JSON) {
            return data.value;
        }
        return null;
    }

    public static JSONObject getJSONObject(Map<String, Data> map, String key) {
        Data data = MapUtil.getData(map, key);
        if (data != null && data.type == ValueType.JSON) {
            return JSON.parseObject((String)data.value);
        }
        return null;
    }

    public static String getXMLString(Map<String, Data> map, String key) {
        Data data = MapUtil.getData(map, key);
        if (data != null && data.type == ValueType.XML) {
            return data.value;
        }
        return null;
    }

    public static String getText(Map<String, Data> map, String key) {
        Data data = MapUtil.getData(map, key);
        if (data != null && data.type == ValueType.TEXT) {
            return data.value;
        }
        return null;
    }

    public static Map<String, Object> sortByKey(Map srcMap, final boolean asc) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                if (asc) {
                    return obj1.compareTo(obj2);
                }
                return obj2.compareTo(obj1);
            }
        });
        sortedMap.putAll(srcMap);
        return sortedMap;
    }

    public static JSONObject toJSONObject(Map<String, Data> srcMap) {
        JSONObject respJSON = new JSONObject();
        for (Map.Entry<String, Data> entry : srcMap.entrySet()) {
            try {
                respJSON.put(entry.getKey(), JSONObject.parse((String)entry.getValue().value));
            }
            catch (Exception ex) {
                respJSON.put(entry.getKey(), (Object)entry.getValue().value);
            }
        }
        return respJSON;
    }
}

