package com.bizvane.rights.vo.hotel.roomtype;

import com.bizvane.rights.vo.OptUserVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class RightsHotelRoomTypeAddRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("房型名称")
    private String roomTypeName;

    @ApiModelProperty("房型代码")
    private String roomTypeCode;

    @ApiModelProperty("房型主图(前端传啥存啥)")
    private String roomMainImage;

    @ApiModelProperty("房型其他图片(前端传啥存啥)")
    private String roomOtherImage;

    @ApiModelProperty("房型原价")
    private BigDecimal roomOriginalPrice;

    @ApiModelProperty("房型员工优惠价")
    private BigDecimal roomEmployeePrice;

    @ApiModelProperty("房型面积")
    private String roomArea;

    @ApiModelProperty("床型信息")
    private String bedType;

    @ApiModelProperty("房间配置")
    private String roomFacilities;

    @ApiModelProperty("备注")
    private String remark;
}
