package com.bizvane.rights.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum EvaluateLabelTypeEnum {


    /**
     * 订单
     */
    BUSINESS_ORDER(1,"商业订单评价"),
    PARKING_SERVICE(2,"停车服务评价"),
    HOTEL_ORDER(3,"酒店预定评价"),
    VIP_ORDER(4,"贵宾订单评价"),
    AIRPORT_GUARD(5,"机场管家评价"),



    /**
     * 服务
     */
    LUGGAGE_TO_DOOR_SERVICE(6,"行李到门服务评价"),
    BARRIER_FREE_PARKING_SERVICE(7,"无障碍车位服务预约"),
    SPECIAL_TRAVELER_SERVICE(8,"特殊旅客服务评价");


    private Integer code;

    private String desc;





    public static EvaluateLabelTypeEnum fromCode(Integer code) {
        for (EvaluateLabelTypeEnum type : EvaluateLabelTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }



}
