package com.bizvane.rights.vo.hotel.order.mobile;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author liuying
 */
@Data
public class RightsHotelPreOrderResponseVO implements Serializable {

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("酒店订单code")
    private String rightsHotelOrderCode;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("酒店名称")
    private String hotelName;

    @ApiModelProperty(value = "预定开始时间", example = "2024-10-10")
    @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
    private LocalDate startDate;

    @ApiModelProperty(value = "预定结束时间", example = "2024-11-11")
    @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
    private LocalDate endDate;

    @ApiModelProperty("数量")
    private Integer quantity;

    @ApiModelProperty("总金额(原价)")
    private BigDecimal totalOriginalAmount;

    @ApiModelProperty("总金额(实际价格,不包含券抵扣金额)")
    private BigDecimal totalActualAmount;

    @ApiModelProperty("总金额(优惠金额,包含券抵扣金额)")
    private BigDecimal totalDiscountAmount;

    @ApiModelProperty("优惠券抵扣金额")
    private BigDecimal couponDiscountPrice;

    @ApiModelProperty("应付金额，扣除所有优惠金额")
    private BigDecimal payableAmount;

    @ApiModelProperty("是否评价：1=未评价；2=已评价")
    private Integer evaluationStatus;

    @ApiModelProperty("可用券数量")
    private long availableCouponCount = 0;
}
