package com.bizvane.rights.vo.hotel.order;

import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsHotelOrderWithMemberResponseVO extends RightsHotelOrderInfoDetailResponseVO implements Serializable {

    @ApiModelProperty("会员信息")
    private MbrMembersDetailVO membersDetailVO;

    @ApiModelProperty("预定价格明细")
    private List<RightsHotelOrderReservationVO> hotelOrderReservationVOList;

    @ApiModelProperty("订单总价")
    private BigDecimal totalPrices;

    @ApiModelProperty("应付金额")
    private BigDecimal payableAmount;

    @ApiModelProperty("几晚酒店")
    private Integer hotelNights;

    @ApiModelProperty("入住/离店")
    private String checkInAndCheckOut;

    @ApiModelProperty("优惠金额(暂时为0,预留以后的优惠券优惠)")
    private BigDecimal discountAmount;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime orderTime;

    @Data
    public static class RightsHotelOrderReservationVO {

        @ApiModelProperty("序号")
        private Integer serialNumber;

        @ApiModelProperty("入住人")
        private String checkInGuest;

        @ApiModelProperty("入住日期")
        @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
        private LocalDate checkInDate;

        @ApiModelProperty("房价")
        private BigDecimal roomRate;
    }
}
