package com.bizvane.rights.vo.evaluate;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


@Data
public class EvaluateLabelResponseVO implements Serializable {

    @ApiModelProperty("评价标签code")
    private String rightsEvaluateLabelCode;

    @ApiModelProperty("标签名称")
    private String labelName;

    @ApiModelProperty("标签类型码")
    private Integer labelType;

    @ApiModelProperty("标签类型对应值,用于展示")
    private String labelTypeDesc;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Boolean valid;

}
