package com.bizvane.rights.feign;

import com.bizvane.rights.vo.OptStatusVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateRequestVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAddOrUpdateResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsAllResponseVO;
import com.bizvane.rights.vo.transit.benefits.TransitBenefitsDetailResponseVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideUpdateRequestVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 无障碍车位预约feign
 *
 * @author liuying
 */
@Api(value = "中转服务", tags = "中转服务")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/transitBenefits")
public interface TransitBenefitsFeign {

    @ApiOperation(value = "查询中转服务到达权益列表", notes = "查询中转服务到达权益列表", httpMethod = "GET")
    @GetMapping("all")
    ResponseData<TransitBenefitsAllResponseVO> all();

    @ApiOperation(value = "权益类型查询权益详情", notes = "权益类型查询权益详情", httpMethod = "GET")
    @GetMapping("detailByRightsType")
    ResponseData<TransitBenefitsDetailResponseVO> detailByRightsType(@RequestParam("rightsType") Integer rightsType);

    @ApiOperation(value = "新增或更新中转服务权益", notes = "新增或更新中转服务权益", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<TransitBenefitsAddOrUpdateResponseVO> addOrUpdate(@RequestBody TransitBenefitsAddOrUpdateRequestVO requestVO);

    @ApiOperation(value = "查询中转联程指南", notes = "查询中转联程指南", httpMethod = "GET")
    @GetMapping("queryTransitGuide")
    ResponseData<TransitGuideVO> queryTransitGuide();

    @ApiOperation(value = "更新中转联程指南(支持新增)", notes = "更新中转联程指南(支持新增)", httpMethod = "POST")
    @PostMapping("updateTransitGuide")
    ResponseData<OptStatusVO> updateTransitGuide(@RequestBody TransitGuideUpdateRequestVO requestVO);
}
