package com.bizvane.rights.feign;

import com.bizvane.rights.vo.special.RightsSpecialPassengerSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 特殊旅客记录
 *
 * @author liuying
 */
@Api(value = "特殊旅客记录", tags = "特殊旅客记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/specialPassenger")
public interface SpecialPassengerFeign {

    @ApiOperation(value = "保存特殊旅客记录", notes = "保存特殊旅客记录", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody RightsSpecialPassengerSaveRequestVO requestVO);

}
