package com.bizvane.rights.feign;

import com.bizvane.rights.vo.parking.order.RightsParkingOrderSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 停车记录feign
 *
 * @author liuying
 */
@Api(value = "停车记录", tags = "停车记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/parkingOrder")
public interface ParkingOrderFeign {

    @ApiOperation(value = "保存停车记录接口", notes = "保存停车记录接口", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody RightsParkingOrderSaveRequestVO requestVO);
}
