package com.bizvane.rights.feign;


import com.bizvane.rights.vo.parking.luggage.RightsLuggageDoorToDoorSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 行李门到门feign
 * @author liuying
 */
@Api(value = "行李门到门", tags = "行李门到门")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/luggageDoorToDoor")
public interface LuggageDoorToDoorFeign {

    @ApiOperation(value = "保存行李门到门记录接口", notes = "保存行李门到门记录接口", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody RightsLuggageDoorToDoorSaveRequestVO requestVO);
}
