package com.bizvane.rights.vo.evaluate;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class RightEvaluateResponseVO {


    @ApiModelProperty("评价code")
    private String rightsEvaluateCode;

    @ApiModelProperty("评价日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime evaluateDate;

    @ApiModelProperty("评价类型订单类型:1:商业订单评价,2:停车服务评价,3:酒店预定评价,4:贵宾订单评价,5:机场管家评价," +
            "6:行李到门服务评价,7:无障碍车位服务预约,8:特殊旅客服务评价")
    private Integer evaluateType;

    @ApiModelProperty("评价类型对应值,用于展示")
    private String evaluateDesc;

    @ApiModelProperty("订单/服务编号")
    private String orderNo;

    @ApiModelProperty("商户code")
    private String merchantCode;

    @ApiModelProperty("商户名")
    private String merchantName;

    @ApiModelProperty("业态code")
    private String businessCode;

    @ApiModelProperty("业态名")
    private String businessName;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("会员卡号")
    private String memberCardNo;

    @ApiModelProperty("满意度程度")
    private Integer satisfactionDegree;

    @ApiModelProperty("评价标签code")
    private String rightsEvaluateLabelCode;

    @ApiModelProperty("留言建议")
    private String suggest;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Integer valid;

    @ApiModelProperty("备注")
    private String remark;



//    @ApiModelProperty("订单类型码")
//    private String orderType;
//    @ApiModelProperty("订单类型名称")
//    private String orderTypeDesc;

    @ApiModelProperty("订单code")
    private String orderCode;


    @ApiModelProperty("评价标签名称")
    private String labelName;
}
