/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.quicka.auth;

import com.aliyuncs.quicka.auth.AlibabaCloudCredentials;
import com.aliyuncs.quicka.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.quicka.auth.EnvironmentVariableCredentialsProvider;
import com.aliyuncs.quicka.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.quicka.auth.SystemPropertiesCredentialsProvider;
import com.aliyuncs.quicka.exceptions.ClientException;
import com.aliyuncs.quicka.utils.AuthUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private List<AlibabaCloudCredentialsProvider> defaultProviders = new ArrayList<AlibabaCloudCredentialsProvider>();
    private static final List<AlibabaCloudCredentialsProvider> USER_CONFIGURATION_PROVIDERS = new Vector<AlibabaCloudCredentialsProvider>();

    public DefaultCredentialsProvider() throws ClientException {
        this.defaultProviders.add(new SystemPropertiesCredentialsProvider());
        this.defaultProviders.add(new EnvironmentVariableCredentialsProvider());
        String roleName = AuthUtils.getEnvironmentECSMetaData();
        if (roleName != null) {
            if (roleName.length() == 0) {
                throw new ClientException("Environment variable roleName('ALIBABA_CLOUD_ECS_METADATA') cannot be empty");
            }
            this.defaultProviders.add(new InstanceProfileCredentialsProvider(roleName));
        }
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        AlibabaCloudCredentials credential;
        if (USER_CONFIGURATION_PROVIDERS.size() > 0) {
            for (AlibabaCloudCredentialsProvider provider : USER_CONFIGURATION_PROVIDERS) {
                credential = provider.getCredentials();
                if (null == credential) continue;
                return credential;
            }
        }
        for (AlibabaCloudCredentialsProvider provider : this.defaultProviders) {
            credential = provider.getCredentials();
            if (null == credential) continue;
            return credential;
        }
        throw new ClientException("not found credentials");
    }

    public static boolean addCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.add(provider);
    }

    public static boolean removeCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.remove(provider);
    }

    public static boolean containsCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.contains(provider);
    }

    public static void clearCredentialsProvider() {
        USER_CONFIGURATION_PROVIDERS.clear();
    }
}

