package com.bizvane.platform.feign.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * AI工具表
 */
@Getter
@Setter
@ApiModel(value = "TSysToolsConfig对象", description = "AI工具表")
public class TSysToolsConfigVo implements Serializable {

    @ApiModelProperty("pkid")
    private Long id;

    @ApiModelProperty("租户ID")
    private String tenantId;

    @ApiModelProperty("工具code")
    private String toolsCode;

    @ApiModelProperty("工具名称")
    private String name;

    @ApiModelProperty("关联工作流id")
    private String workflowId;

    @ApiModelProperty("logo")
    private String logo;

    @ApiModelProperty("描述")
    private String desc;

    @ApiModelProperty("创作要求（json字符串）")
    private String requireConfig;

    @ApiModelProperty("状态：0=禁用；1=启用")
    private Boolean status;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty("备注")
    private String remark;
}
