package com.bizvane.platform.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户账号
 * </p>
 */
@Getter
@Setter
public class TSysAccountVo implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "租户id")
    private String tenantId;

    @ApiModelProperty(value = "租户名字")
    private String tenantName;

    @ApiModelProperty(value = "账户code")
    private String accountCode;

    @ApiModelProperty(value = "手机")
    private String phone;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "状态：0=禁用；1=启用")
    private Boolean status;

    @ApiModelProperty(value = "强制修改密码标志位：1=需要，0=不需要")
    private Boolean resetPassword;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人id")
    private String createUserCode;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private String modifiedUserCode;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "上次登录时间")
    private Date lastLoginTime;

    private Boolean valid;


}
