package com.bizvane.platform.feign.feign.wx;

import com.bizvane.platform.feign.model.req.WxAuthReq;
import com.bizvane.platform.feign.model.req.WxGetUserInfoReq;
import com.bizvane.platform.feign.model.rsp.WxGetPhoneNumberInfoRsp;
import com.bizvane.platform.feign.model.rsp.WxGetUserInfoRsp;
import com.bizvane.platform.feign.model.vo.WxAuthOpenidVo;
import com.bizvane.platform.feign.model.vo.WxAuthVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;


@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}/wxAuth")
public interface WechatAuthRpcFeign {

    @PostMapping("/login")
    @ResponseBody
    @ApiOperation(value = "登录")
    ResponseData<WxAuthVo> login(@RequestBody @Validated WxAuthReq req);


    @PostMapping("/getUserInfo")
    @ResponseBody
    @ApiOperation(value = "获取微信用户信息")
    ResponseData<WxGetUserInfoRsp> getUserInfo(@RequestBody @Validated WxGetUserInfoReq req);


    @PostMapping("/getPhoneNumber")
    @ResponseBody
    @ApiOperation(value = "获取微信手机号")
    ResponseData<WxGetPhoneNumberInfoRsp> getPhoneNumber(@RequestBody @Validated WxAuthReq req);


    @PostMapping("/getOpenid")
    @ResponseBody
    @ApiOperation(value = "获取openid")
    ResponseData<WxAuthOpenidVo> getOpenid(@RequestBody @Validated WxAuthReq req);

}
