package com.bizvane.platform.feign.feign.basic;

import com.bizvane.platform.feign.model.vo.TSysCryptoDataVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysCrypto")
@Api(value = "加密、解密RPC")
public interface SysCryptoRpcFeign {

    @RequestMapping(value = "/encryptData", method = RequestMethod.POST)
    @ApiOperation(value = "加密")
    ResponseData<String> encryptData(@RequestBody @Validated TSysCryptoDataVo vo);

    @RequestMapping(value = "/decryptData", method = RequestMethod.POST)
    @ApiOperation(value = "解密")
    ResponseData<String> decryptData(@RequestBody @Validated TSysCryptoDataVo vo);
}
