package com.bizvane.platform.feign.feign.wx;

import com.bizvane.platform.feign.model.req.base.WxBaseAppIdReq;
import com.bizvane.platform.feign.model.vo.TWxMiniAppVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}/tWxMiniApp")
public interface WechatMiniAppRpcFeign {

    @PostMapping("/getMiniAppInfo")
    @ResponseBody
    @ApiOperation(value = "获取小程序配置")
    ResponseData<TWxMiniAppVo> getMiniAppInfo(@RequestBody @Validated WxBaseAppIdReq req);

    @PostMapping("/getMembersMiniAppInfo")
    @ResponseBody
    @ApiOperation(value = "获取会员中心小程序配置")
    ResponseData<TWxMiniAppVo> getMembersMiniAppInfo();

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "列表")
    @ResponseBody
    ResponseData<List<TWxMiniAppVo>> list(@RequestBody TWxMiniAppVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加")
    @ResponseBody
    ResponseData<Boolean> save(@RequestBody TWxMiniAppVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑")
    @ResponseBody
    ResponseData<Boolean> modify(@RequestBody TWxMiniAppVo req);

}
