package com.bizvane.platform.feign.feign.basic;

import com.bizvane.platform.feign.model.vo.TSysMenuVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tBasicMenu")
@Api(value = "菜单RPC")
public interface BasicMenuRpcFeign {

    @RequestMapping(value = "/getAllMenuAndBtnList", method = RequestMethod.POST)
    @ApiOperation(value = "获取所有菜单列表")
    ResponseData<List<TSysMenuVO>> getAllMenuAndBtnList();

}
