package com.bizvane.platform.feign.model.req.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class BasePageReq implements Serializable {
    private static final long serialVersionUID = -3298905916732287960L;

    @ApiModelProperty(notes = "页数", required = true)
    @NotNull(message = "页数不能为空")
    private Integer pageNum = 1;

    @ApiModelProperty(notes = "每页条数", required = true)
    @NotNull(message = "每页条数不能为空")
    private Integer pageSize = 10;

    @ApiModelProperty(allowableValues = "0", notes = "第一次获取传0，后面传返回的数据")
    @JsonIgnore
    private Integer total = 0;

}
