package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.req.AccountLoginReq;
import com.bizvane.platform.feign.model.req.TSysAccountPageReq;
import com.bizvane.platform.feign.model.vo.TSysAccountAddOrModifyVo;
import com.bizvane.platform.feign.model.vo.TSysAccountSaveVo;
import com.bizvane.platform.feign.model.vo.TSysAccountVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysStaff")
@Api(value = "员工信息RPC")
public interface SysStaffRpcFeign {


    @RequestMapping(value = "/login", method = RequestMethod.POST)
    @ApiOperation(value = "小程序登录")
    ResponseData<TSysAccountVo> login(@RequestBody AccountLoginReq accountLoginReq);

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysAccountAddOrModifyVo>> pageList(@RequestBody TSysAccountPageReq req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加员工")
    ResponseData<Boolean> save(@RequestBody TSysAccountSaveVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "修改员工")
    ResponseData<Boolean> modify(@RequestBody TSysAccountAddOrModifyVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "员工详情")
    ResponseData<TSysAccountAddOrModifyVo> detail(@RequestBody TSysAccountAddOrModifyVo req);


}
