package com.bizvane.platform.feign.model.req;

import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import lombok.Setter;


/**
 * 修改密码
 */
@Getter
@Setter
public class TSysAccountChangePasswordReq {

    @ApiModelProperty(value = "账户code")
    @NotBlank(message = "账号不能为空")
    private String accountCode;
    @ApiModelProperty(value = "旧密码")
    private String oldPassword;
    @ApiModelProperty(value = "新密码")
    private String newPassword;
    @ApiModelProperty(value = "类型（1修改密码 2重置密码）")
    @NotNull(message = "类型不能为空")
    private Integer type;


}
