package com.bizvane.payment.feign.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class NotifyOrderPayVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("支付系统订单编号code")
    private String paymentPayOrderCode;

    @ApiModelProperty("商户支付配置系统编号code")
    private String paymentMerchantConfigCode;

    @ApiModelProperty("支付通道 微信：WEIXIN_TYPE 工商:ICBC_TYPE")
    private String payChannelType;

    @ApiModelProperty("支付类型 微信：WEIXIN 支付宝:ALIPAY")
    private String payType;

    @ApiModelProperty("支付场景类型 PaymentChannelTypeEnum")
    private String channelType;

    @ApiModelProperty("外部支付交易号")
    private String outTradeNo;

    @ApiModelProperty("平台系统生成的单号")
    private String channelTradeNo;

    @ApiModelProperty("平台系统生成的支付流水ID")
    private String channelPayTransactionId;

    @ApiModelProperty("用户openid")
    private String openid;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("用户支付附加数据")
    private String attach;

    @ApiModelProperty("订单总金额(元)")
    private BigDecimal totalAmount;

    @ApiModelProperty("已退款金额(元)")
    private BigDecimal refundedAmount;

    @ApiModelProperty("交易状态：0待支付 1支付成功 2支付关闭 3支付退款")
    private Integer tradeStatus;

    @ApiModelProperty("交易状态描述")
    private String tradeStatusDesc;

    @ApiModelProperty("支付数据包")
    private String dataPackage;

    @ApiModelProperty("支付时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime payTime;

    @ApiModelProperty("关闭时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime closeTime;

}
