package com.bizvane.openapi.common.utils;

import java.util.Collection;
import java.util.Map;

import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import com.bizvane.openapi.common.response.CodeMessage;

/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 */
public class Assert {

	/**
	 * 判断条件是否为true, 如不为真 抛出异常
	 * @param expression
	 * @param codeMessage
	 */
	public static void isTrue(boolean expression, CodeMessage codeMessage) {
		if (!expression) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 必填参数检查
	 * @param text 检查内容
	 * @param args
	 */
	public static void missing(String text, String ... args) {
		hasText(text, CodeMessage.newInstance(CodeConsts.MISSING_PARAMETER_NAME, args));
	}
	
	/**
	 * 必填参数检查
	 * @param object 检查内容
	 * @param args
	 */
	public static void missing(Object object, String ... args) {
		notNull(object, CodeMessage.newInstance(CodeConsts.MISSING_PARAMETER_NAME, args));
	}
	
	public static void notInvalidResource(Object object, String ... args) {
		notNull(object, CodeMessage.newInstance(CodeConsts.INVALID_RESOURCE_NOT_FOUND, args));
	}
	
	/**
	 * 判断条件是否为true, 如不为真 抛出异常
	 * @param expression
	 * @param message
	 */
	@Deprecated
	public static void isTrue(boolean expression, String message) {
		if (!expression) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	/**
	 * 判断对象是否为空,如果为空,则抛出异常
	 * @param object
	 * @param codeMessage
	 */
	public static void notNull(Object object, CodeMessage codeMessage) {
		if (object == null) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 判断对象是否为空,如果不为空,则抛出异常
	 * @param object
	 * @param message
	 */
	@Deprecated
	public static void isNull(Object object, String message) {
		if (object != null) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	/**
	 * 判断对象是否为空,如果不为空,则抛出异常
	 * @param object
	 * @param codeMessage
	 */
	public static void isNull(Object object, CodeMessage codeMessage) {
		if (object != null) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 判断对象是否为空,如果为空,则抛出异常
	 * @param object
	 * @param message
	 */
	@Deprecated
	public static void notNull(Object object, String message) {
		if (object == null) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	
	
	/**
	 * 判断字符串是否有值, 没值抛出异常
	 * @param text
	 * @param codeMessage
	 */
	public static void hasLength(String text, CodeMessage codeMessage) {
		if (!StringUtils.hasLength(text)) {
			throw new OpenApiException(codeMessage);
		}
	}


	
	/**
	 * 判断字符串是否有值, 没值抛出异常
	 * @param text
	 * @param message
	 */
	@Deprecated
	public static void hasLength(String text, String message) {
		if (!StringUtils.hasLength(text)) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	/**
	 * 判断字符串是否有值, 没值抛出异常
	 * @param text
	 * @param codeMessage
	 */
	public static void hasText(String text, CodeMessage codeMessage) {
		if (!StringUtils.hasText(text)) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 判断字符串是否有值, 没值抛出异常
	 * @param text
	 * @param message
	 */
	@Deprecated
	public static void hasText(String text, String message) {
		if (!StringUtils.hasText(text)) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	/**
	 * 判断集合是否有值,没值抛出异常
	 * @param collection
	 * @param codeMessage
	 */
	public static void notEmpty(Collection<?> collection, CodeMessage codeMessage) {
		if (CollectionUtils.isEmpty(collection)) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 判断集合是否有值,没值抛出异常
	 * @param collection
	 * @param message
	 */
	@Deprecated
	public static void notEmpty(Collection<?> collection, String message) {
		if (CollectionUtils.isEmpty(collection)) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
	
	/**
	 * 判断map是否有值,没值抛出异常
	 * @param map
	 * @param codeMessage
	 */
	public static void notEmpty(Map<?, ?> map, CodeMessage codeMessage) {
		if (CollectionUtils.isEmpty(map)) {
			throw new OpenApiException(codeMessage);
		}
	}
	
	/**
	 * 判断map是否有值,没值抛出异常
	 * @param map
	 * @param message
	 */
	@Deprecated
	public static void notEmpty(Map<?, ?> map, String message) {
		if (CollectionUtils.isEmpty(map)) {
			throw new OpenApiException(new CodeMessage(CodeConsts.CLIENT_ERROR, message));
		}
	}
}
