package com.bizvane.openapi.common.trace;


import java.time.Duration;
import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 
 * @author wang.zeyan
 * @date 2019年5月29日
 */
@ConfigurationProperties(prefix = "bizvane.trace.controller")
@Data
@Accessors(chain = true)
public class TraceControllerProperties {
	
	/**
	 * 是否开启
	 */
	private boolean enabled = true;
	
	/**
	 * 跳过的方法名
	 */
	private String skipPattern = "";
	
	/**
	 * 日志name, default current class
	 */
	private String loggerName;
	
	/**
	 * 输出headers
	 */
	private boolean outRequestHeader = false;
	
	/**
	 * 输出header指定的名称列表
	 */
	private List<String> outRequestHeaderNames;
	
	/**
	 * 输出query
	 */
	private boolean outRequestQuery = true;
	
	/**
	 * 输出form
	 */
	private boolean outRequestForm = true;
	
	/**
	 * 输出requestBody
	 */
	private boolean outRequestBody = true;
	
	/**
	 * 输出执行结果
	 */
	private boolean outResponseResult = false;
	
	/**
	 * 输出结果最大长度
	 */
	private int outResponseMaxLenth = 200; 
	
	/**
	 * 慢请求阀值
	 */
	private Duration slowThreshold;
}
