package com.bizvane.openapi.common.trace;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.regex.Pattern;

/**
 * @author wang.zeyan
 * 2019年5月29日
 */
@Configuration
@EnableConfigurationProperties(TraceControllerProperties.class)
public class TraceControllerAutoConfiguration {


    @Configuration
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    public static class TraceServlet {

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value = "bizvane.trace.controller.enabled", matchIfMissing = true)
        public TraceControllerAspect tranceControllerAspect(TraceControllerProperties properties) {
            return new TraceControllerAspect(Pattern.compile(properties.getSkipPattern()), properties);
        }
    }


    @Configuration
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
    public static class TraceReactive {


    }
}
