package com.bizvane.openapi.common.retrofit;


import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.request.HttpRequestHandler;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

/**
 * 
 * @author wang.zeyan
 *  2019年4月10日
 */
@Configuration
@ConditionalOnClass(Retrofit.class)
@ConditionalOnBean(OkHttpClient.class)
public class RetrofitAutoConfiguration {

	Logger log = LoggerFactory.getLogger(RetrofitAutoConfiguration.class);
	
	@Bean("bizvane-retrofit")
	public Retrofit retrofit(OkHttpClient okHttpClient) {
		log.info("Create retrofit");
		Retrofit retrofit = new Retrofit.Builder()
				.client(okHttpClient)
				.baseUrl("http://www.bizvane.com")
				.addConverterFactory(JacksonConverterFactory.create())
				.build();
		return retrofit;
	}
	
	@Bean
	public HttpService httpService(Retrofit retrofit) {
		log.info("Create retrofit httpService");
		return retrofit.create(HttpService.class);
	}
	
	@Bean 
	public HttpRequest httpRequest(HttpService httpService) {
		log.info("Create httpRequest");
		return new HttpRequestHandler(httpService);
	}
}
