package com.bizvane.openapi.common.retrofit;

import java.util.Map;
import java.util.concurrent.CompletableFuture;


import retrofit2.http.*;

/**
 * 
 * @author wang.zeyan
 *  2019年4月10日
 */
public interface HttpService {

	/**
	 * get请求
	 * @param url
	 * @return
	 */
	@GET
	CompletableFuture<Object> get(@Url String url);
	
	/**
	 * get请求
	 * @param url
	 * @param params queryParams
	 * @return
	 */
	@GET
	CompletableFuture<Object> get(@Url String url, @QueryMap Map<String, Object> params);
	
	/**
	 * get请求
	 * @param url
	 * @param params queryParams
	 * @param headers headers
	 * @return
	 */
	@GET
	CompletableFuture<Object> get(@Url String url, @QueryMap Map<String, Object> params, @HeaderMap Map<String, Object> headers);
	
	/**
	 * post请求
	 * @param url
	 * @return
	 */
	@POST
	CompletableFuture<Object> postBody(@Url String url);
	
	/**
	 * post请求
	 * @param url
	 * @param body requestBody
	 * @return
	 */
	@POST
	CompletableFuture<Object> postBody(@Url String url, @Body Map<String, Object> body);
	
	/**
	 * post请求
	 * @param url
	 * @param body requestBody
	 * @param headers headers
	 * @return
	 */
	@POST
	CompletableFuture<Object> postBody(@Url String url, @Body Map<String, Object> body, @HeaderMap Map<String, Object> headers);
	
	/**
	 * post请求
	 * @param url
	 * @param body requestBody
	 * @param queryParams queryParams
	 * @param headers headers
	 * @return
	 */
	@POST
	CompletableFuture<Object> postBody(@Url String url, @Body Map<String, Object> body, @QueryMap Map<String, Object> queryParams, @HeaderMap Map<String, Object> headers);


	/**
	 * post 请求
	 * @param url
	 * @param params
	 * @return
	 */
	@FormUrlEncoded
	@POST
	CompletableFuture<Object> post(@Url String url, @FieldMap Map<String, Object> params);

	/**
	 * post 请求
	 * @param url
	 * @param params
	 * @param headers
	 * @return
	 */
	@FormUrlEncoded
	@POST
	CompletableFuture<Object> post(@Url String url, @FieldMap Map<String, Object> params, @HeaderMap Map<String, Object> headers);

	/**
	 * post请求
	 * @param url
	 * @param params
	 * @param queryParams
	 * @param headers
	 * @return
	 */
	@FormUrlEncoded
	@POST
	CompletableFuture<Object> post(@Url String url, @FieldMap Map<String, Object> params, @QueryMap Map<String, Object> queryParams, @HeaderMap Map<String, Object> headers);
	/**
	 * put请求
	 * @param url
	 * @return
	 */
	@PUT
	CompletableFuture<Object> putBody(@Url String url);
	
	/**
	 * put请求
	 * @param url
	 * @param body requestBody
	 * @return
	 */
	@PUT
	CompletableFuture<Object> putBody(@Url String url, @Body Map<String, Object> body);
	
	/**
	 * put请求
	 * @param url
	 * @param body requestBody
	 * @param headers headers
	 * @return
	 */
	@PUT
	CompletableFuture<Object> putBody(@Url String url, @Body Map<String, Object> body, @HeaderMap Map<String, Object> headers);
	
	/**
	 * put请求
	 * @param url
	 * @param body requestBody
	 * @param params queryParams
	 * @param headers headers
	 * @return
	 */
	@PUT
	CompletableFuture<Object> putBody(@Url String url, @Body Map<String, Object> body, @QueryMap Map<String, Object> params,@HeaderMap Map<String, Object> headers);
	
	/**
	 * delete请求
	 * @param url
	 * @return
	 */
	@DELETE
	CompletableFuture<Object> delete(@Url String url);
	
	/**
	 * delete请求
	 * @param url
	 * @param params queryParams
	 * @return
	 */
	@DELETE
	CompletableFuture<Object> delete(@Url String url, @QueryMap Map<String, Object> params);
	
	/**
	 * delete请求
	 * @param url
	 * @param params queryParams
	 * @param headers headers
	 * @return
	 */
	@DELETE
	CompletableFuture<Object> delete(@Url String url, @QueryMap Map<String, Object> params, @HeaderMap Map<String, Object> headers);
	
	
}
