package com.bizvane.openapi.common.response;

import org.springframework.boot.context.properties.ConfigurationProperties;

import com.bizvane.openapi.common.consts.StringConsts;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 
 * @author wang.zeyan
 *  2019年5月31日
 */
@ConfigurationProperties(prefix = "bizvane.response")
@Data
@Accessors(chain = true)
public class ResponseProperties {

	/**
	 * 错误输出模式
	 */
	private OutMode statusOutMode = OutMode.Body;
	
	private OutMode idOutMode = OutMode.Body;
	
	private String id = StringConsts.REQUEST_ID;
	private String code = StringConsts.STATUS_CODE;
	
	/**
	 * reason
	 */
	private String msg = StringConsts.STATUS_MESSAGE;
	private String result = StringConsts.RESULT;
	
	public enum OutMode {
		/**
		 * 输出内容到body中
		 */
		Body,
		/**
		 * 输出内容到 header中
		 */
		Header
	}
}
