package com.bizvane.openapi.common.response;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 
 * @author wang.zeyan
 *  2019年5月30日
 */
@Configuration
@EnableConfigurationProperties(ResponseProperties.class)
public class ResponseAutoConfiguration {

	@ConditionalOnMissingBean
	@Bean
	public CodeMessageController codeMessageController(ApplicationContext ctx) {
		return new CodeMessageController();
	}

	@Configuration
	@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
	public static class ResponseServlet {

		@ConditionalOnMissingBean
		@Bean
		public RestControllerExpAdviceHandler restControllerExpAdviceHandler(ResponseProperties properties) {
			return new RestControllerExpAdviceHandler(properties);
		}
	}

	@Configuration
	@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
	public static class ResponseReactive {

		/*@ConditionalOnMissingBean
		@Bean
		@Order(Ordered.HIGHEST_PRECEDENCE + 6)
		public ReactiveAddTraceIdFilter reactiveTraceResponse(ResponseProperties properties) {

			return new ReactiveAddTraceIdFilter(properties);
		}*/

		/*@ConditionalOnMissingBean
		@Bean
		public ReactiveRestControllerExpAdviceHandler restControllerExpHandlerReactive(ResponseProperties properties) {
			return new ReactiveRestControllerExpAdviceHandler(properties);
		}*/
	}

}
