
package com.bizvane.openapi.common.response;

import static com.bizvane.openapi.common.consts.CodeMessageConsts.Base.UNKNOWN;

import java.util.HashMap;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.consts.StringConsts;
/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 * 
 * 2019.5.30 修改返回方式,直接返回对象,错误信息将在header中返回
 */
public class Response extends HashMap<String, Object> {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public Response() {
	}
	
	public static Response error() {
		return error(UNKNOWN);
	}
	
	public static Response error(CodeMessage codeMessage) {
		Response r = new Response();
		r.put(StringConsts.STATUS_CODE, codeMessage.getCode());
		r.put(StringConsts.STATUS_MESSAGE, codeMessage.getMsg());
		return r;
	}
	
	public static Response error(String message) {
		Response r = new Response();
		r.put(StringConsts.STATUS_CODE, CodeConsts.SERVER_ERROR.value());
		r.put(StringConsts.STATUS_MESSAGE, message);
		return r;
	}
	
	public static Response ok(Object result) {
		Response r = new Response();
		r.put(StringConsts.STATUS_CODE, CodeConsts.SUCCESS.value());
		r.put(StringConsts.RESULT, result);
		return r;
	}
	
	public static Response ok() {
		Response r = new Response();
		r.put(StringConsts.STATUS_CODE, CodeConsts.SUCCESS.value());
		return r;
	}

	@Override
	public Response put(String key, Object value) {
		super.put(key, value);
		return this;
	}
}
