package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.consts.StringConsts;
import com.bizvane.openapi.common.exception.OpenApiException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;

/**
 * @author wang.zeyan
 * 2020/02/03
 */
@ControllerAdvice(annotations = RestController.class)
@Slf4j
public class ReactiveRestControllerExpAdviceHandler {


    private ResponseProperties properties = new ResponseProperties();

    public ReactiveRestControllerExpAdviceHandler() {
        super();
        diffProperties();
    }

    public ReactiveRestControllerExpAdviceHandler(ResponseProperties properties) {
        this.properties = properties;
        diffProperties();
    }

    private void diffProperties() {
        if (!StringConsts.STATUS_CODE.equals(properties.getCode())) {
            this.diffCode = true;
        }
        if (!StringConsts.RESULT.equals(properties.getResult())) {
            this.diffResult = true;
        }
    }

    private boolean diffCode, diffResult;


    @ExceptionHandler(value = Exception.class)
    public Response defaultExceptionHandler(Exception e, ServerWebExchange exchange) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }

        Response result = null;
        HttpStatus code = CodeConsts.SERVER_ERROR;
        String message = null;
        if (e instanceof OpenApiException) {
            OpenApiException exception = (OpenApiException) e;
            message = exception.getCodeMessage().getMsg();
            code = exception.getCodeMessage().getCode();
        } else {
            log.error(" Rest controller base exception ", e);
            message = ExceptionUtils.getRootCauseMessage(e);
        }
        exchange.getResponse().setStatusCode(code);
        exchange.getResponse().getHeaders().add(properties.getMsg(), message);
        return result;
    }
}
