/*
package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.StringConsts;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

*/
/**
 * @author wang.zeyan 2019/12/31
 *//*

public class ReactiveAddTraceIdFilter implements WebFilter {

    private ResponseProperties properties;

    public ReactiveAddTraceIdFilter(ResponseProperties properties) {
        this.properties = properties;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Object trace = exchange.getAttribute("org.springframework.cloud.sleuth.instrument.web.TraceWebFilter.TRACE");

        System.out.println(trace);
        String requestId = MDC.get(StringConsts.TRACE_ID);
        if(StringUtils.hasText(requestId)) {
            exchange.getResponse().getHeaders().add(properties.getId(), requestId);
        }
        return chain.filter(exchange);
    }
}
*/
