package com.bizvane.openapi.common.response;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

import com.bizvane.openapi.common.annotation.EnableResponseCodeMessage;
import com.bizvane.openapi.common.consts.CodeConsts;

/**
 * 
 * @author wang.zeyan
 *  2019年6月4日
 */
public class CodeMessageRegistrar implements ImportBeanDefinitionRegistrar, ResourceLoaderAware, BeanClassLoaderAware, EnvironmentAware {

	private ResourceLoader resourceLoader;

	private ClassLoader classLoader;
	
	private Environment environment;
	
	public CodeMessageRegistrar(){
		
	}
	
	@Override
	public void setEnvironment(Environment environment) {
		this.environment = environment;
	}

	@Override
	public void setBeanClassLoader(ClassLoader classLoader) {
		this.classLoader = classLoader;
	}

	@Override
	public void setResourceLoader(ResourceLoader resourceLoader) {
		this.resourceLoader = resourceLoader;
	}

	@Override
	public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
		registerIceClients(metadata, registry);
	}

	private void registerIceClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
		ClassPathScanningCandidateComponentProvider scanner = getScanner();
		scanner.setResourceLoader(this.resourceLoader);
		
		AssignableTypeFilter annotationTypeFilter = new AssignableTypeFilter(CodeConsts.class);
		scanner.addIncludeFilter(annotationTypeFilter);
		
		Set<String> basePackages = getBasePackages(metadata);
		for (String basePackage : basePackages) {
			Set<BeanDefinition> candidateComponents = scanner.findCandidateComponents(ClassUtils.getPackageName(basePackage));
			for (BeanDefinition candidateComponent : candidateComponents) {
				String clazz = candidateComponent.getBeanClassName();
				try {
					Class<?> forName = ClassUtils.forName(clazz, classLoader);
					Field[] fields = forName.getFields();
					for (Field field : fields) {
						
						if(Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getType().isAssignableFrom(CodeMessage.class)) {
							try {
								Object object = field.get(forName);
								CodeMessage cm = (CodeMessage) object;
								CodeMessageController.add(cm);
							} catch (IllegalArgumentException | IllegalAccessException e) {
								e.printStackTrace();
							}
						}
					}
				} catch (ClassNotFoundException e) {
					// skip
				} catch (LinkageError e) {
					// skip
				}
			}
		}
	}

	/**
	 * @return
	 */
	private ClassPathScanningCandidateComponentProvider getScanner(){
		return new ClassPathScanningCandidateComponentProvider(false, this.environment) {
			@Override
			protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
				return true;
			}
			
		};
	}
	
	/**
	 * @param importingClassMetadata
	 * @return
	 */
	protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
		Map<String, Object> attributes = importingClassMetadata
				.getAnnotationAttributes(EnableResponseCodeMessage.class.getCanonicalName());
		Set<String> basePackages = new HashSet<>();
		for (String pkg : (String[]) attributes.get("value")) {
			if (StringUtils.hasText(pkg)) {
				basePackages.add(pkg);
			}
		}
		if (basePackages.isEmpty()) {
			basePackages.add(
					ClassUtils.getPackageName(importingClassMetadata.getClassName()));
		}
		return basePackages;
	}

}
