package com.bizvane.openapi.common.response;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.google.common.base.Strings;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.http.HttpStatus;

/**
 * @author wang.zeyan
 * 2019年4月11日
 */
@Data
@Accessors(chain = true)
public class CodeMessage {

    /**
     * http错误状态码
     */
    private HttpStatus code;

    /**
     * 错误消息
     */
    private String msg;

    /**
     * 错误描述
     */
    private String description;

    @SuppressWarnings("unused")
    private CodeMessage() {
    }

    @Deprecated
    public CodeMessage(HttpStatus code, String msg) {
        super();
        this.code = code;
        this.msg = msg;
        this.description = msg;
    }

    private CodeMessage(HttpStatus code, String msg, String desc) {
        super();
        this.code = code;
        this.msg = msg;
        this.description = desc;
    }

    public static CodeMessage newInstance(HttpStatus code, String msg, String desc) {
        CodeMessage cm = new CodeMessage(code, msg, desc);
        return cm;
    }

    public static CodeMessage newInstance(HttpStatus code, String msg) {
        return newInstance(code, msg, msg);
    }

    public static CodeMessage newClientInstance(String msg) {
        return newInstance(CodeConsts.CLIENT_ERROR, msg);
    }

    public static CodeMessage newClientInstance(String msg, String desc) {
        return newInstance(CodeConsts.CLIENT_ERROR, msg, desc);
    }

    public static CodeMessage newServerInstance(String msg) {
        return newInstance(CodeConsts.SERVER_ERROR, msg);
    }

    public static CodeMessage newServerInstance(String msg, String desc) {
        return newInstance(CodeConsts.SERVER_ERROR, msg, desc);
    }

    private final static String PATTERN = "(\\{[a-zA-Z.-_]{0,}\\})";

    public static CodeMessage newInstance(CodeMessage cm, String... args) {
        if (cm == null) {
            return null;
        }
        if (Strings.emptyToNull(cm.getMsg()) == null) {
            return cm;
        }
        String msg = cm.getMsg();

        if (args == null || args.length == 0) {
            msg.replaceAll(PATTERN, "");
        } else {
            for (String arg : args) {
                msg = msg.replaceFirst(PATTERN, arg);
            }
        }
        return newInstance(cm.getCode(), msg);
    }

    @Override
    public String toString() {
        return msg;
    }
}
