package com.bizvane.openapi.common.request;

import java.util.Map;

/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 */
public interface HttpRequest {

	public static interface HttpRequestMethod {
		String GET = "get";
		String POST = "post";
		String POST_FORM = "post_form";
		String PUT = "put";
		String DELETE = "delete";
	}
	
	/**
	 * 请求处理
	 * @param method  'get','post','put','delete'
	 * @param url
	 * @param body requestbody /form-data
	 * @param queryParams queryParams
	 * @param headers headers
	 * @param clazz 
	 * @return
	 */
	<T> T request(String method, String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz);
	//Response<JsonObject> synRequestRetrofit(String method, String url, Map<String, Object> body, Map<String, Object> params, Map<String, Object> headers);
	
	/**
	 * get 请求块
	 * @param url
	 * @return
	 */
	String get(String url);
	<T> T get(String url, Class<T> clazz);
	<T> T get(String url, Map<String, Object> params, Class<T> clazz);
	<T> T get(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz);
	
	/**
	 * post body 请求块
	 * @param url
	 * @return
	 */
	String postBody(String url);
	<T> T postBody(String url, Class<T> clazz);
	<T> T postBody(String url, Map<String, Object> body, Class<T> clazz);
	<T> T postBody(String url, Map<String, Object> body, Map<String, Object> headers, Class<T> clazz);
	<T> T postBody(String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz);

	/**
	 * post 请求快
	 * @param url
	 * @param clazz
	 * @param <T>
	 * @return
	 */
	<T> T post(String url, Class<T> clazz);
	<T> T post(String url, Map<String, Object> params, Class<T> clazz);
	<T> T post(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz);
	<T> T post(String url, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz);
	/**
	 * put 请求块
	 * @param url
	 * @return
	 */
	String putBody(String url);
	<T> T putBody(String url, Class<T> clazz);
	<T> T putBody(String url, Map<String, Object> body, Class<T> clazz);
	<T> T putBody(String url, Map<String, Object> body, Map<String, Object> headers, Class<T> clazz);
	<T> T putBody(String url, Map<String, Object> body, Map<String, Object> queryParams, Map<String, Object> headers, Class<T> clazz);
	
	/**
	 * delete请求块
	 * @param url
	 * @return
	 */
	String delete(String url);
	<T> T delete(String url, Class<T> clazz);
	<T> T delete(String url, Map<String, Object> params, Class<T> clazz);
	<T> T delete(String url, Map<String, Object> params, Map<String, Object> headers, Class<T> clazz);
}
