package com.bizvane.openapi.common.p6spy;

import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.option.P6OptionsRepository;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wang.zeyan
 * 2019年6月6日
 */
public class P6SlowSqlOptions implements P6SlowSqlLoadableOptions {

    public static final String SLOW_THRESHOLD = "slowthreshold";

    protected static final Map<String, String> DEFAULTS;

    private final P6OptionsRepository optionsRepository;

    public P6SlowSqlOptions(final P6OptionsRepository optionsRepository) {
        this.optionsRepository = optionsRepository;
    }

    static {
        DEFAULTS = new HashMap<String, String>();
        DEFAULTS.put(SLOW_THRESHOLD, Long.toString(3000));
    }

    @Override
    public void setSlowThreshold(String slowThreshold) {
        optionsRepository.set(Long.class, SLOW_THRESHOLD, slowThreshold);
    }

    @Override
    public long getSlowThreshold() {
        return optionsRepository.get(Long.class, SLOW_THRESHOLD);
    }

    @Override
    public void load(Map<String, String> options) {
        setSlowThreshold(options.get(SLOW_THRESHOLD));
    }

    @Override
    public Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    public static P6SlowSqlOptions getActiveInstance() {
        return P6ModuleManager.getInstance().getOptions(P6SlowSqlOptions.class);
    }

}
