package com.bizvane.openapi.common.p6spy;

import com.p6spy.engine.event.JdbcEventListener;
import com.p6spy.engine.logging.P6LogOptions;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6LoadableOptions;
import com.p6spy.engine.spy.option.P6OptionsRepository;

/**
 * 慢日志factory
 * @author wang.zeyan
 *  2019年6月6日
 */
public class P6SlowSqlLogFactory implements P6Factory {
	
	@Override
	public P6LoadableOptions getOptions(P6OptionsRepository optionsRepository) {
		return new P6LogOptions(optionsRepository);
	}

	@Override
	public JdbcEventListener getJdbcEventListener() {
	    return SlowSqlJdbcEventListener.INSTANCE;
	}

}
