package com.bizvane.openapi.common.okhttp3;

import java.util.concurrent.TimeUnit;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 
 * @author wang.zeyan
 *  2019年4月10日
 */
@ConfigurationProperties(prefix = "bizvane.okhttp3")
public class OkHttp3Properties {

	private static TimeUnit defaultTimeUnit = TimeUnit.MILLISECONDS;
	private TimeUnit timeUnit = defaultTimeUnit;
	private long readTimeout = 3000;
	private long writeTimeout = 3000;
	private long connectTimeout = 3000;
	private boolean followRedirects = false;

	public TimeUnit getTimeUnit() {
		return timeUnit;
	}

	public void setTimeUnit(TimeUnit timeUnit) {
		this.timeUnit = timeUnit;
	}

	public long getReadTimeout() {
		return readTimeout;
	}

	public void setReadTimeout(long readTimeout) {
		this.readTimeout = readTimeout;
	}

	public long getWriteTimeout() {
		return writeTimeout;
	}

	public void setWriteTimeout(long writeTimeout) {
		this.writeTimeout = writeTimeout;
	}

	public long getConnectTimeout() {
		return connectTimeout;
	}

	public void setConnectTimeout(long connectTimeout) {
		this.connectTimeout = connectTimeout;
	}

	public boolean isFollowRedirects() {
		return followRedirects;
	}

	public void setFollowRedirects(boolean followRedirects) {
		this.followRedirects = followRedirects;
	}
}
