package com.bizvane.openapi.common.okhttp3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

/**
 * 
 * @author wang.zeyan
 *  2019年4月10日
 */
@Configuration
@ConditionalOnClass(OkHttpClient.class)
@EnableConfigurationProperties(OkHttp3Properties.class)
public class OkHttp3AutoConfiguration {

	Logger log = LoggerFactory.getLogger(OkHttp3AutoConfiguration.class);
	
	@ConditionalOnMissingBean
	@Bean("bizvane-okHttpClient")
	public OkHttpClient okHttpClient(OkHttp3Properties properties, ApplicationContext context) {
		log.info("Create okHttpClient");
		okhttp3.OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
		builder
		.readTimeout(properties.getReadTimeout(), properties.getTimeUnit())
		.writeTimeout(properties.getWriteTimeout(), properties.getTimeUnit())
		.connectTimeout(properties.getConnectTimeout(), properties.getTimeUnit())
		.followRedirects(properties.isFollowRedirects());
		
		//项目中设置头信息
		/*Interceptor headerInterceptor = new Interceptor() {

			@Override
			public Response intercept(Chain chain) throws IOException {
				Request originalRequest = chain.request();
		        Request.Builder requestBuilder = originalRequest.newBuilder()
		                .addHeader("Accept-Encoding", "gzip")
		                .addHeader("Accept", "application/json")
		                .addHeader("Content-Type", "application/json; charset=utf-8")
		                .method(originalRequest.method(), originalRequest.body());
		        Request request = requestBuilder.build();
		        return chain.proceed(request);
			}
		};
		builder.addInterceptor(headerInterceptor);*/
		String[] beanNames= context.getBeanNamesForType(Interceptor.class);
		if(beanNames != null && beanNames.length > 0) {
			for (String beanName : beanNames) {
				Interceptor bean = context.getBean(beanName, Interceptor.class);
				builder.addInterceptor(bean);
			}
		}
		return builder.build();
	}
}
