package com.bizvane.openapi.common.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;

import java.util.regex.Pattern;

/**
 * @author wang.zeyan
 * 2019年6月5日
 */
public class Slf4JLogger extends FormattedLogger {

    private Logger log;

    public Slf4JLogger() {
        log = LoggerFactory.getLogger("com.bizvane.openapi.common.sqlLog");
    }

    @Override
    public void logException(Exception e) {
        log.info("", e);
    }

    @Override
    public void logText(String text) {
        log.info(text);
    }

    final static Pattern P = Pattern.compile("(\\r?\n(\\s*\\r?\\n)+)");

    @Override
    public void logSQL(int connectionId, String now, long elapsed,
                       Category category, String prepared, String sql, String url) {
        sql = P.matcher(sql).replaceAll("\\\r\\\n");
        final String msg = strategy.formatMessage(connectionId, now, elapsed,
                category.toString(), prepared, sql, url);

        if (Category.ERROR.equals(category) || Category.OUTAGE.equals(category)) {
            log.error(msg);
        } else if (Category.WARN.equals(category)) {
            log.warn(msg);
        } else if (Category.DEBUG.equals(category)) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
    }

    @Override
    public boolean isCategoryEnabled(Category category) {
        if (Category.ERROR.equals(category)) {
            return log.isErrorEnabled();
        } else if (Category.WARN.equals(category)) {
            return log.isWarnEnabled();
        } else if (Category.DEBUG.equals(category)) {
            return log.isDebugEnabled();
        } else {
            return log.isInfoEnabled();
        }
    }

}
