package com.bizvane.openapi.common.listener;

import java.util.Collection;
import java.util.Map;

import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

import com.p6spy.engine.spy.P6SpyOptions;

/**
 * 将spring配置 spy.config 转为p6spy需要的System spy.properties
 * @author wang.zeyan
 *  2019年5月22日
 */
public class P6spyConfigListener implements ApplicationListener<ApplicationContextInitializedEvent>, Ordered {

	@Override
	public int getOrder() {
		return Ordered.HIGHEST_PRECEDENCE;
	}

	private static final String DEFAULT_P6SPY_NAME = "p6spy.properties";
	
	@SuppressWarnings("unchecked")
	@Override
	public void onApplicationEvent(ApplicationContextInitializedEvent event) {

		ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
		String p6spyName = environment.getProperty("config.p6spy", environment.getProperty("spring.application.name") + "-p6spy.properties");
		
		MutablePropertySources propertySources = environment.getPropertySources();
		PropertySource<?> propertySource = propertySources.get("bootstrapProperties");
		if(propertySource == null) {
			return ;
		}
		
		if(propertySource instanceof CompositePropertySource) {
			CompositePropertySource cp = (CompositePropertySource) propertySource;
			
			PropertySource<?> nacosSource = getSource("NACOS", cp.getPropertySources());
			if(nacosSource == null) {
				return ;
			}
			
			if(nacosSource instanceof CompositePropertySource) {
				CompositePropertySource nacos = (CompositePropertySource) nacosSource;
				PropertySource<?> p6spySource = getSource(p6spyName, nacos.getPropertySources());
				if(p6spySource == null) {
					return ;
				}
				
				Object source = p6spySource.getSource();
				if(source == null || !(source instanceof Map)) {
					return ;
				}
				Map<String, String> options = (Map<String, String>) source;
				if(CollectionUtils.isEmpty(options)) { 
					p6spySource = getSource(DEFAULT_P6SPY_NAME, nacos.getPropertySources());
					if(p6spySource == null) {
						return ;
					}
					source = p6spySource.getSource();
					if(source == null || !(source instanceof Map)) {
						return ;
					}
					options = (Map<String, String>) source;
				}
				
				P6SpyOptions.getActiveInstance().load(options);
				/*for(Map.Entry<String, String> entry : map.entrySet()) {
					System.setProperty(String.format("%s%s", "p6spy.config.", entry.getKey()), entry.getValue());
				}*/
			}
		}
	}
	
	private PropertySource<?> getSource(String sourceName, Collection<PropertySource<?>> collectionSource){
		for (PropertySource<?> subSource : collectionSource) {
			if(sourceName.equals(subSource.getName())) {
				return subSource;
			}
		}
		return null;
	}
}
